<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

use Verta;
use App\Models\User;
use App\Models\panel\settings;
use App\Models\panel\sms\sendSms;


class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        $request->session()->regenerate();

        return redirect()->intended(route('dashboard', absolute: false));
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }









    public function captchaAjax(Request $request)
    {
        return response()->json([
            "imageSrc" => captcha_src(),
        ]);
    }
	public function newLogin(Request $request)
    {
        $request->validate([
            'password' => 'required|min:6',
            'captcha' => 'required|captcha',
        ]);


        if(is_numeric($request->get('username'))){

            $request->validate([
                'username' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric',
            ]);
            $login = "phone";
        }else{
            $request->validate([
                'username'   => 'required|email',
            ]);
            $login = "email";
        }



        if (Auth::attempt([$login => $request->username, 'password' => $request->password], $request->get('remember'))) {
            $find_id = User::where($login,$request->username)->pluck('id')[0];
            $find_user = User::find($find_id);
            if($find_user ->account_type  == 1){
                return redirect()->intended('/panel/index');
            }else{
                if($find_user ->active == 1){
                    if($find_user ->active_sms == 1){
                        $settings = settings::find(1);
                        if($settings != null){
                            $attributes = json_decode($settings->activation,true);
                            if($attributes == true){
                                $send_sms_login = $attributes[0]['send_sms_login'];
                                if($send_sms_login == 1){
                                    $url = url('');
                                    $text = 'شما با موفقیت به حساب کاربری خود وارد شدید';
                                    $time = Verta::now()->format('Y-n-j H:i');
                                    $pm_sms = ' سلام ' . $find_user -> name . ' عزیز '.PHP_EOL.
                                    $text.PHP_EOL.
                                    'تاریخ ورود : '.PHP_EOL.$time.PHP_EOL.
                                    'نام سایت : '.$settings -> site_name;
                                    
                                    $phone = $find_user ->phone;

                                    $new_send_sms = new sendSms();
                                    $sending = $new_send_sms -> sendSms($pm_sms,$phone);
    
                                }
                            }
                        }
                    }

                    return redirect()->intended('/client/index');
                }else{
                    return \Redirect::back()->withErrors('کاربری شما مسدود شده است لطفا با پشتیبانی تماس بگیرید')->withInput();
                }
            }
            
        }else{
                return \Redirect::back()->withErrors('ایمیل یا پسورد اشتباه است')->withInput();
        }
        return back()->withInput($request->only($login, 'remember'));
    }











}
