<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

use App\Models\User;
use Kavenegar\KavenegarApi;
use App\Models\panel\sms\sendSms;
use App\Mail\sendCodeRecoveryEmail;
use Illuminate\Support\Facades\Mail;
use App\Models\panel\sms\configurationSms;




class PasswordController extends Controller
{
    /**
     * Update the user's password.
     */
    public function update(Request $request): RedirectResponse
    {
        $validated = $request->validateWithBag('updatePassword', [
            'current_password' => ['required', 'current_password'],
            'password' => ['required', Password::defaults(), 'confirmed'],
        ]);

        $request->user()->update([
            'password' => Hash::make($validated['password']),
        ]);

        return back()->with('status', 'password-updated');
    }











	public function newForgotPassword(Request $request)
    {
        $request->validate([
            'captcha' => 'required|captcha',
        ]);


        if(is_numeric($request->get('username'))){
            $request->validate([
                'username' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric',
            ]);
            $login = "phone";
        }else{
            $request->validate([
                'username'   => 'required|email',
            ]);
            $login = "email";
        }

        if($login == "phone"){
            $configurationSms = configurationSms::find(1);
            if(($configurationSms != null)){
                $phone = $request -> username;
                //$randomid = rand(100,10000); 
                $digits = 4;
                $randomid = rand(pow(10, $digits-1), pow(10, $digits)-1);

                $id_user = User::where('phone',$phone)->pluck('id')->toArray();
                if($id_user !=[]){
                    $find_user = User::find($id_user[0]);
                    $name = $find_user -> name;
                    if($find_user -> active != 0){
                        $find_user = User::find($id_user[0]);
                        $find_user-> code_confirmation = $randomid;
                        $find_user->save();
            
                        $pm_sms = ' سلام ' . $name . ' عزیز '.PHP_EOL.
                        'کد شما : '.PHP_EOL.$randomid;
                        
						$new_send_sms = new sendSms();
						$sending = $new_send_sms -> sendSms($pm_sms,$phone);
						if($sending["status"] == 1){
                            return redirect('/changePasswordClient')->with('success','کد با موفقیت ارسال شد');
						}else{
							return back()->with('success','متاسفانه پیامک با موفقیت ارسال نشد');
						}

                    }else{
                        return back()->with('error','کاربری شما مسدود شده است لطفا با پشتیبانی تماس بگیرید');
                    }
    
                }else{
                    return back()->with('error','نمایندی با این شماره موبایل پیدا نشد');
                }
            }else{
                return back()->with('error','متاسفانه پیامک با موفقیت ارسال نشد');
            }

        }else{
            $email = $request -> username;
            $id_user = User::where('email',$email)->pluck('id')->toArray();
            if($id_user !=[]){
                $find_user = User::find($id_user[0]);
                if($find_user -> active != 0){
                    $digits = 4;
                    $randomid = rand(pow(10, $digits-1), pow(10, $digits)-1);
    
                    $mailData = [
                        'title' => 'کد ارسال شده : ',
                        'body' => $randomid
                    ];
    
                    $find_user = User::find($id_user[0]);
                    $find_user-> code_confirmation = $randomid;
                    $find_user->save();
    
                    Mail::to($email)->send(new sendCodeRecoveryEmail($mailData));
                    
                    return redirect('/changePasswordClient')->with('success','کد با موفقیت ارسال شد');
                }else{
                    return back()->with('error','کاربری شما مسدود شده است لطفا با پشتیبانی تماس بگیرید');
                }
            }else{
                return back()->with('error','نمایندی با این ایمیل پیدا نشد');
            }
        }
    }


    public function changePasswordClient(){
        return view('auth.passwords.phone');
    }

    public function updatePasswordClient(Request $request){

        $request->validate([
            'password' => 'required|string|min:6|confirmed',
        ]);


        if(is_numeric($request->get('username'))){
            $request->validate([
                'username' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric',
            ]);

            $login = "phone";
        }else{
            $request->validate([
                'username'   => 'required|email',
            ]);
            $login = "email";
        }

        $code = $request -> code;
        $username = $request -> username;
        $id_user = User::where($login,$username)->pluck('id')->toArray();
        if($id_user !=[]){
            $find_user = User::find($id_user[0]);
            $name = $find_user -> name;
            if($find_user -> active != 0){
                if($find_user -> code_confirmation == $code){
                    $find_user = User::find($id_user[0]);
                    $find_user-> code_confirmation = null;
                    $find_user -> password  = Hash::make($request->password);
                    $find_user->save();
                    return redirect('/login')->with('success','پسورد شما با موفقیت تغییر یافت. لطفا لاین کنید');
                }else{
                    return back()->with('error','کد وارد شده صحیح نمی باشد');
                }
            }else{
                return back()->with('error','کاربری شما مسدود شده است لطفا با پشتیبانی تماس بگیرید');
            }

        }else{
            return back()->with('error','نمایندی با این شماره موبایل پیدا نشد');
        }

    }







}
