<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;

use App\Models\panel\settings;
use App\Models\panel\sms\sendSms;





class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        return view('auth.register');
    }


    public function registerClient(){
        return view('auth.register');
    }
    public function createClient(Request $request){

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
            'phone' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric|unique:users',
			'captcha' => 'required|captcha',
        ]);

        $User = new User();
        $User -> name = $request -> name;
        $User -> email = $request -> email;
        $User -> wallet = $request -> wallet;
        $User -> phone = $request -> phone;
        $User -> password  = Hash::make($request->password);
        $User -> account_type = 2;
        $User -> active = 2;
        $User -> save();


        $settings = settings::find(1);
        if($settings != null){
            $attributes = json_decode($settings->activation,true);
            if($attributes == true){
                $send_sms_register = $attributes[0]['send_sms_register'];
                if($send_sms_register == 1){
                    $text = 'ثبت نام شما با موفقیت انجام شد';

                    $pm_sms = ' سلام ' . $User -> name . ' عزیز '.PHP_EOL.
                    $text.PHP_EOL.
                    'نام سایت : '.$settings -> site_name;
                    
                    $phone = $User ->phone;
                    $new_send_sms = new sendSms();
                    $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                }
            }
        }

        return redirect('/login')->with('success','کاربری شما با موفقیت ایجاد شد لطفا لاگین کنید');

    }







    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:'.User::class],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        event(new Registered($user));

        Auth::login($user);

        return redirect(route('dashboard', absolute: false));
    }
}
