<?php

namespace App\Http\Controllers\client;
use App\Models\panel\factor;
use Illuminate\Http\Request;

use App\Models\panel\campaign;
use App\Http\Controllers\Controller;
use App\Models\panel\category_campaign;

class campaignController extends Controller
{
    public function allCampaign(){
        $campaign = campaign::orderBy('created_at','desc')->paginate(10);
        $CategoryCampaign = category_campaign::orderBy('created_at','desc')->get();
        $count_campaignok = campaign::orderBy('created_at','desc')->where('status',1)->count();
        return view('client.campaign.allCampaign',compact('campaign','CategoryCampaign','count_campaignok'));
    }

    public function searchCategoryCampaign($id){
        $campaign = campaign::orderBy('created_at','desc')->where('id_category',$id)->paginate(10);
        $CategoryCampaign = category_campaign::orderBy('created_at','desc')->get();
        $count_campaignok = campaign::orderBy('created_at','desc')->where('status',1)->count();
        return view('client.campaign.allCampaign',compact('campaign','CategoryCampaign','count_campaignok'));
    }

    public function allCampaignSupported(){
        $id_user = \Auth::user() -> id;
        $factor = factor::orderBy('created_at','desc')->where('client_id',$id_user)->where('name_factor','factorCampaign')->paginate(10);
        return view('client.campaign.allCampaignSupported',compact('factor'));
    }


    public function campaign($id){
        $campaign = campaign::find($id);
        return view('client.campaign.campaign',compact('campaign'));
    }

    public function crateFactorCampaign(Request $request , $id){
        $request->validate([
            'price' => 'required|numeric',
        ]);
        $id_user = \Auth::user() -> id;
        $phone = \Auth::user() -> phone;
        $name = \Auth::user() -> name;
        $campaign = campaign::find($id);

        $array_factor = array(
            'id_campaign' => $campaign -> id,
            'campaign' => $campaign,
            'id_category_campaign' => $campaign -> id_category,
        );

        $new_factor = new factor();
        $new_factor -> name_factor = "factorCampaign";
        $new_factor -> client_id = $id_user;
        $new_factor -> items_factor = $array_factor;
        $new_factor -> price = $request -> price;
        $new_factor -> phone = $phone;
        $new_factor -> name = $name;
        $new_factor -> payment = 0;
        $new_factor -> type_name = "client";
        $new_factor -> campaign_id = $campaign -> id;
        $new_factor ->save();
        return redirect('client/factor'.'/'.$new_factor -> id)->with('success',' فاکتور حمایت از کمپین '.$campaign -> name.' با موفقیت ایجاد شد . بعد از پرداخت فاکتور به جمع حامیان می پیوندید ');
    }
    
}
