<?php

namespace App\Http\Controllers\panel;

use Illuminate\Http\Request;
use App\Models\panel\department;
use App\Http\Controllers\Controller;

class departmentController extends Controller
{
    
    public function addDepartment(){
        return view('panel.department.addDepartment');
    }

    public function allDepartment(){
        $all_department = department::orderBy('created_at','desc')->paginate(10);
        return view('panel.department.allDepartment',compact('all_department'));
    }

    public function editDepartment($id){
        $department = department::find($id);
        return view('panel.department.editDepartment',compact('department'));
    }

    public function create(Request $request){
        $request->validate([
            'name' => 'required|string|max:255|unique:department',
            'active' => 'nullable|string',
        ]);
 
        $Department = new department();
        $Department -> name = $request -> name;
        if($request -> active){
        $Department -> active = 1;
        }else{
        $Department -> active = 0;
        }
        $Department -> save();
        return back()->with('success','دپارتمان با موفقیت ایجاد شد');
    }

    public function updateDepartment(Request $request , $id){
        $request->validate([
            'name' => 'required|string|max:255',
            'active' => 'nullable|string',
        ]);
        $Department = department::find($id);
        $Department -> name = $request -> name;
        if($request -> active){
            $Department -> active = 1;
         }else{
            $Department -> active = 0;
         }
        $Department -> save();
        return back()->with('success','دپارتمان با موفقیت ویرایش شد');
    }

    public function deleteDepartment($id){
        department::find($id) -> delete();
        return back()->with('success','دپارتمان با موفقیت حذف شد');
    }
}
