<?php

namespace App\Http\Controllers\panel;

use App\Models\User;
use Kavenegar\KavenegarApi;
use App\Models\panel\factor;
use Illuminate\Http\Request;
use App\Models\panel\customers;
use App\Models\panel\phone_virtual;
use App\Http\Controllers\Controller;
use App\Models\sms\configurationSms;
use App\Models\sms\smsir\smsIr_sendMessage;

class factorController extends Controller
{



    public function panelFactor($id){
        $factor = factor::find($id);
        return view('panel.factor.factor',compact('factor'));
    }

    public function allFactorNotPay(){
        $factor = factor::orderBy('created_at','desc')
        ->where('payment',0)
        ->paginate(10);
        return view('panel.factor.allFactorNotPay',compact('factor'));
    }
    public function allFactorPayed(){
        $factor = factor::orderBy('created_at','desc')
        ->paginate(10);
        return view('panel.factor.allFactorPayed',compact('factor'));
    }

    public function searchFactorNotPay(Request $request){
        $query = factor::orderBy('created_at','desc')->where('payment',0);
        if ($request->filled('search') && $request->filled('selectvalue')) {
            if ($request->selectvalue == 'name') {
                $query->where('name', 'LIKE', '%' . $request->search . '%');
            } elseif ($request->selectvalue == 'phone') {
                $query->where('phone', 'LIKE', '%' . $request->search . '%');
            }
        }
        if ($request->typeFactor == 'campaign') {
            $query->where('name_factor', 'factorCampaign');
        } elseif ($request->typeFactor == 'subsidy') {
            $query->where('name_factor', 'factorSubsidy');
        } elseif ($request->typeFactor == 'product') {
            $query->where('name_factor', 'factorProduct');
        }

        $factor = $query->paginate(10);
        $factor->appends(request()->input())->links();
        return view('panel.factor.allFactorNotPay',compact('factor'));
    }
    public function searchFactorPayed(Request $request){
        $query = factor::orderBy('created_at','desc');
        if ($request->filled('search') && $request->filled('selectvalue')) {
            if ($request->selectvalue == 'name') {
                $query->where('name', 'LIKE', '%' . $request->search . '%');
            } elseif ($request->selectvalue == 'phone') {
                $query->where('phone', 'LIKE', '%' . $request->search . '%');
            }
        }

        if ($request->typeFactor == 'campaign') {
            $query->where('name_factor', 'factorCampaign');
        } elseif ($request->typeFactor == 'subsidy') {
            $query->where('name_factor', 'factorSubsidy');
        } elseif ($request->typeFactor == 'product') {
            $query->where('name_factor', 'factorProduct');
        }

        $factor = $query->paginate(10);
        $factor->appends(request()->input())->links();
        return view('panel.factor.allFactorPayed',compact('factor'));
    }

    public function deleteFactor($id){
        factor::find($id) -> delete();
        return back()->with('success','فاکتور با موفقیت حذف شد');
    }

}
