<?php

namespace App\Http\Controllers\panel\product;

use App\Models\panel\carts;
use App\Models\panel\factor;
use App\Models\panel\address_home;
use Illuminate\Http\Request;
use App\Models\panel\product;
use App\Http\Controllers\Controller;
use App\Models\panel\category_product;

class productController extends Controller
{
    
    public function addProduct(){
        $categoryProduct = category_product::orderBy('created_at','desc')->get();
        return view('panel.product.product.addProduct',compact('categoryProduct'));
    }

    
    public function editProduct($id){
        $categoryProduct = category_product::orderBy('created_at','desc')->get();
        $Product = product::find($id);
        return view('panel.product.product.editProduct',compact('Product','categoryProduct'));
    }


    public function allProduct(){
        $Product = product::orderBy('created_at','desc')->paginate(10);
        return view('panel.product.product.allProduct',compact('Product'));
    }


    public function create(Request $request){
        $request->validate([
            'name' => 'required|string',
            'price' => 'required|numeric',
            'categoryProduct' => 'required|numeric',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $Product = new product();
        $Product -> name = $request -> name ;
        $Product -> price = $request -> price ;
        $Product -> id_category = $request -> categoryProduct ;
        if($request -> active){
            $Product -> active = 1;
        }else{
            $Product -> active = 0;
        }
        $Product -> save();

        $image = $request -> image -> getClientOriginalName();
        $Product -> image = $request -> image -> getClientOriginalName();
        $request -> file('image') -> move('upload/Product', $image);
        $Product -> save();



        return back()->with('success','محصول با موفقیت ایجاد شد');
    }



    public function updateProduct(Request $request , $id){
        $request->validate([
            'name' => 'required|string',
            'price' => 'required|numeric',
            'categoryProduct' => 'required|numeric',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);

        $Product = product::find($id);
        $Product -> name = $request -> name ;
        $Product -> price = $request -> price ;
        $Product -> id_category = $request -> categoryProduct ;
        if($request -> active){
            $Product -> active = 1;
        }else{
            $Product -> active = 0;
        }
        $Product -> save();

        if($request -> image){
            $image = $request -> image -> getClientOriginalName();
            $Product -> image = $request -> image -> getClientOriginalName();
            $request -> file('image') -> move('upload/Product', $image);
            $Product -> save();
        }
        return back()->with('success','محصول با موفقیت ویرایش شد');
    }

    public function deleteProduct($id){
        product::find($id) -> delete();
        return back()->with('success','محصول با موفقیت حذف شد');
    }











    public function allBuyProduct(){
        $allOrder = factor::where('name_factor',"factorProduct")->settlementStatusCustom()->paginate(10);
        return view('panel.product.product.allBuyProduct',compact('allOrder'));
    }

    public function profileProduct($id){
        $find_factor = factor::find($id);
        $id_user = $find_factor -> client_id;
        $AddressHome = address_home::orderBy('created_at','desc')->where('client_id',$id_user)->get();
        return view('panel.product.product.profileProduct',compact('find_factor','AddressHome'));
    }


    public function searchFactorBuyProduct(Request $request){
        $query = factor::where('name_factor',"factorProduct");

        if ($request->filled('search') && $request->filled('selectvalue')) {
            if ($request->selectvalue == 'name') {
                $query->where('name', 'LIKE', '%' . $request->search . '%');
            } elseif ($request->selectvalue == 'phone') {
                $query->where('phone', 'LIKE', '%' . $request->search . '%');
            }elseif ($request->selectvalue == 'id') {
                $query->where('id',$request->search);
            }
        }

        $allOrder = $query->settlementStatusCustom()->paginate(10);
        $allOrder->appends(request()->input())->links();
        return view('panel.product.product.allBuyProduct',compact('allOrder'));
    }




    public function changeOrder(Request $request,$id){
        $id_user = \Auth::user() -> id;
        $phone = \Auth::user() -> phone;
        $name = \Auth::user() -> name;
        $request->validate([
            'address' => 'required|numeric',
            'status' => 'required|numeric',
            'TrackingCode' => 'required|string',
        ]);

        $find_factor = factor::find($id);
        $find_address = address_home::find($request -> address);
        $find_factor->items_factor = array_merge(
            $find_factor->items_factor,
            [
                'StatusSend'   => $request -> status,
                'TrackingCode' => $request -> TrackingCode,
                'AddressId'    => $find_address->id,
                'Address'      => $find_address,
            ]
        );
        $find_factor->save();
        return back()->with('success','سفارش با موفقیت ویرایش  شد');
        
    }







}
