<?php

namespace App\Http\Controllers\panel;

use App\Models\User;
use Kavenegar\KavenegarApi;
use Illuminate\Http\Request;
use App\Models\panel\sms\sendSms;
use App\Http\Controllers\Controller;
use App\Models\panel\sms\configurationSms;
use App\Models\panel\sms\smsir\smsIr_sendMessage;

class smsController extends Controller
{
    public function index(){
        $configurationSms = configurationSms::all();
        return view('panel.sms.configurationSms',compact('configurationSms'));
    }








    //---------------------------------------------------------
    public function sendSms(){
        $configurationSms = configurationSms::all();
        return view('panel.sms.sendSms',compact('configurationSms'));
    }
    public function goSendSms(Request $request){
        $request->validate([
            'pm_sms' => 'required|string',
            'panel_sms' => 'required',
        ]);
        $panel_sms = $request -> panel_sms;
        $pm_sms = $request -> pm_sms;
        $customers = User::where('account_type',2)->where('active',1)->get();
        $uniqueCollection = $customers->unique('phone') -> pluck('phone') -> toArray();
        $phone = $uniqueCollection;

        $new_send_sms = new sendSms();
        $sending = $new_send_sms -> sendSms($pm_sms,$phone,$panel_sms);
        if($sending["status"] == 1){
            return back()->with('success','پیامک با موفقیت ارسال شد');
        }else{
            return back()->with('error','متاسفانه پیامک با موفقیت ارسال نشد');
        }

    }
    //---------------------------------------------------------
    public function sendSmsUser(){
        $configurationSms = configurationSms::all();
        $customers = User::where('account_type',2)->get();
        return view('panel.sms.sendSmsUser',compact('configurationSms','customers'));
    }
    public function goSendSmsUser(Request $request){

        $request->validate([
            'pm_sms' => 'required|string',
            'reseller' => 'required',
            'panel_sms' => 'required',
        ]);
        $panel_sms = $request -> panel_sms;
        $customers = User::find($request -> reseller);
        $pm_sms = $request -> pm_sms;
        $phone = $customers -> phone;
        $new_send_sms = new sendSms();
        $sending = $new_send_sms -> sendSms($pm_sms,$phone,$panel_sms);
        if($sending["status"] == 1){
            return back()->with('success','پیامک با موفقیت ارسال شد');
        }else{
            return back()->with('error','متاسفانه پیامک با موفقیت ارسال نشد');
        }
    }



























    public function configurationSmsIr(Request $request){
        $request->validate([
            'APIKey' => 'required|string',
            'phone' => 'required|numeric',
        ]);
   
        $configurationSms = configurationSms::where('name','smsir')->get();
        if($configurationSms -> toArray() == []){
            $arrays = array(
                'APIKey' => $request -> APIKey,
                'phone' => $request -> phone,
            );
            $new_configurationSms = new configurationSms();
            $new_configurationSms -> name = "smsir";
            $new_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $new_configurationSms -> active = 1;
            }else{
                $new_configurationSms -> active = 0;
            }
            $new_configurationSms -> save();

        }else{
            $arrays = array(
                'APIKey' => $request -> APIKey,
                'phone' => $request -> phone,
            );
            $find_configurationSms = $configurationSms -> pluck('id')[0];
            $edit_configurationSms = configurationSms::find($find_configurationSms);
            $edit_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $edit_configurationSms -> active = 1;
            }else{
                $edit_configurationSms -> active = 0;
            }
            $edit_configurationSms -> save();
        }

        return back()->with('success','تنظیمات با موفقیت انجام شد');
    }





    public function configurationKavenegar(Request $request){
        $request->validate([
            'username' => 'required|string',
            'phone' => 'required|numeric',
        ]);
   
        $configurationSms = configurationSms::where('name','kavenegar')->get();
        if($configurationSms -> toArray() == []){
            $arrays = array(
                'username' => $request -> username,
                'phone' => $request -> phone,
            );
            $new_configurationSms = new configurationSms();
            $new_configurationSms -> name = "kavenegar";
            $new_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $new_configurationSms -> active = 1;
            }else{
                $new_configurationSms -> active = 0;
            }
            $new_configurationSms -> save();

        }else{
            $arrays = array(
                'username' => $request -> username,
                'phone' => $request -> phone,
            );
            $find_configurationSms = $configurationSms -> pluck('id')[0];
            $edit_configurationSms = configurationSms::find($find_configurationSms);
            $edit_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $edit_configurationSms -> active = 1;
            }else{
                $edit_configurationSms -> active = 0;
            }
            $edit_configurationSms -> save();
        }

        return back()->with('success','تنظیمات با موفقیت انجام شد');
    }








    public function configurationMeliPayamak(Request $request){
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
            'phone' => 'required|numeric',
        ]);
   
        $configurationSms = configurationSms::where('name','melipayamak')->get();
        if($configurationSms -> toArray() == []){
            $arrays = array(
                'username' => $request -> username,
                'password' => $request -> password,
                'phone' => $request -> phone,
            );
            $new_configurationSms = new configurationSms();
            $new_configurationSms -> name = "melipayamak";
            $new_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $new_configurationSms -> active = 1;
            }else{
                $new_configurationSms -> active = 0;
            }
            $new_configurationSms -> save();

        }else{
            $arrays = array(
                'username' => $request -> username,
                'password' => $request -> password,
                'phone' => $request -> phone,
            );
            $find_configurationSms = $configurationSms -> pluck('id')[0];
            $edit_configurationSms = configurationSms::find($find_configurationSms);
            $edit_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $edit_configurationSms -> active = 1;
            }else{
                $edit_configurationSms -> active = 0;
            }
            $edit_configurationSms -> save();
        }

        return back()->with('success','تنظیمات با موفقیت انجام شد');
    }











    public function configurationIpPanel(Request $request){
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
            'phone' => 'required|numeric',
        ]);
   
        $configurationSms = configurationSms::where('name','ippanel')->get();
        if($configurationSms -> toArray() == []){
            $arrays = array(
                'username' => $request -> username,
                'password' => $request -> password,
                'phone' => $request -> phone,
            );
            $new_configurationSms = new configurationSms();
            $new_configurationSms -> name = "ippanel";
            $new_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $new_configurationSms -> active = 1;
            }else{
                $new_configurationSms -> active = 0;
            }
            $new_configurationSms -> save();

        }else{
            $arrays = array(
                'username' => $request -> username,
                'password' => $request -> password,
                'phone' => $request -> phone,
            );
            $find_configurationSms = $configurationSms -> pluck('id')[0];
            $edit_configurationSms = configurationSms::find($find_configurationSms);
            $edit_configurationSms -> data = json_encode($arrays);
            if($request -> active){
                $edit_configurationSms -> active = 1;
            }else{
                $edit_configurationSms -> active = 0;
            }
            $edit_configurationSms -> save();
        }

        return back()->with('success','تنظیمات با موفقیت انجام شد');
    }














}
