<?php

namespace App\Http\Controllers\panel;

use App\Models\User;
use Kavenegar\KavenegarApi;
use App\Models\panel\ticket;
use Illuminate\Http\Request;
use App\Models\panel\settings;
use App\Models\panel\pm_ticket;
use App\Models\panel\department;
use App\Models\panel\sms\sendSms;
use App\Http\Controllers\Controller;
use Hekmatinasser\Verta\Facades\Verta;
use App\Models\panel\sms\configurationSms;
use App\Models\panel\sms\smsir\smsIr_sendMessage;

class ticketController extends Controller
{
    public function addTicket(){
        $id_user = \Auth::user() -> id;
        $all_department = department::orderBy('created_at','desc')->get();
        $all_client = User::orderBy('created_at','desc')->where('account_type',2)->get();
        return view('panel.ticket.addTicket',compact('all_department','all_client'));
    }


    public function allTicket(){
        $id_user = \Auth::user() -> id;
        $allTicket = ticket::orderBy('created_at','desc')->paginate(10);
        $all_department = department::orderBy('created_at','desc')->get();
        $all_client = User::orderBy('created_at','desc')->where('account_type',2)->get();
        return view('panel.ticket.allTicket',compact('allTicket','all_department','all_client'));
    }




    public function searchTicket(Request $request){
        $id_user = \Auth::user() -> id;
        $all_department = department::orderBy('created_at','desc')->get();
        $all_client = User::orderBy('created_at','desc')->where('account_type',2)->get();
        $query = ticket::orderBy('created_at','desc');
        

        
        if($request->selectvalue == 'title'){
            $query -> where('title', 'LIKE', '%' . $request->search . '%');
        }
        if($request->selectvalue == 'id'){
            $query -> where('id',$request->search);
        }
        if($request->department){
            $query -> where('department',$request->department);
        }
        if($request->importance){
            $query -> where('importance',$request->importance);
        }
        if($request->status){
            $query -> where('status',$request->status);
        }
        if($request->client){
            $query -> where('client_id',$request->client);
        }

        if((!$request->department) && (!$request->importance) && (!$request->status) && ($request->selectvalue != 'title') && ($request->selectvalue != 'id')){
            $query -> where('title', 'LIKE', '%' . $request->search . '%');
        }


        $allTicket = $query->paginate(10);
        $allTicket->appends(request()->input())->links();

        return view('panel.ticket.allTicket',compact('allTicket','all_department','all_client'));
    }




    public function create(Request $request){
        $id_user = \Auth::user() -> id;
        $request->validate([
            'title' => 'required|string',
            'client' => 'required|numeric',
            'importance' => 'required|numeric',
            'status' => 'required|numeric',
            'department' => 'required|numeric',
            'description' => 'required|string',
            "file" => "nullable|mimes:jpeg,png,jpg,pdf,zip|max:4096"
        ]);

        $ticket = new ticket();
        $ticket -> title = $request -> title;
        $ticket -> importance = $request -> importance;
        $ticket -> department = $request -> department;
        $ticket -> client_id = $request -> client;
        $ticket -> status = $request -> status;
        $ticket -> save();

        $pm_ticket = new pm_ticket();
        $pm_ticket -> description = $request -> description;
        $pm_ticket -> ticket_id = $ticket -> id;
        $pm_ticket -> client_id = $request -> client;
        $pm_ticket -> admin_id = $id_user;
        $pm_ticket -> type = 'admin';
        $pm_ticket -> save();
        if($request->file){
            $file = $request -> file -> getClientOriginalName();
            $pm_ticket -> file = $request -> file -> getClientOriginalName();
            $request -> file('file') -> move('upload/ticket', $file);
            $pm_ticket -> save();
        }

            $find_client = User::find($request -> client);
            $name_client = $find_client -> name;
            $phone_client = $find_client -> phone;
            //ارسال پیامک شروع

            $settings = settings::find(1);
            if($settings != null){
                $attributes = json_decode($settings->activation,true);
                if($attributes == true){
                    $send_sms_ticket_client = $attributes[0]['send_sms_ticket_client'];

                    if(($send_sms_ticket_client == 1) && ($find_client -> active_sms == 1)){// ارسال به نماینده
                        $text = 'شما از طرف ادمین یک تیکت دریافت کردید . لطفا در اسرع وقت به تیکت پاسخ دهید';
                        $pm_sms = ' سلام ' . $name_client . ' عزیز '.PHP_EOL.
                        $text.PHP_EOL.
                        'شماره تیکت : '.$ticket -> id.PHP_EOL.
                        'موضوع : '.$request -> title.PHP_EOL.
                        'نام سایت : '.$settings -> site_name;

                        $phone = $phone_client;
                        $new_send_sms = new sendSms();
                        $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                    }
                        
                    
                }
            }

        return back()->with('success','تیکت با موفقیت ایجاد شد');
    }


    public function ticket($id){
        $id_user = \Auth::user() -> id;
        $ticket = ticket::findOrFail($id);
        $all_pm_ticket = pm_ticket::orderBy('created_at','desc') -> where('ticket_id',$id)->paginate(10);
        return view('panel.ticket.ticket',compact('ticket','all_pm_ticket'));
    }


    public function updateTicket(Request $request , $id){
        $id_user = \Auth::user() -> id;
        if($request -> close){
            $ticket = ticket::find($id);
            $ticket -> status = 2 ;
            $ticket -> save();            
            return back()->with('success','تیک با موفقیت بسته شد');
        }else{
            $request->validate([
                'description' => 'required|string',
                'status' => 'required|numeric',
                "file" => "nullable|mimes:jpeg,png,jpg,pdf,zip|max:4096"
            ]);
            $ticket = ticket::find($id);
            $ticket -> status = $request -> status;
            $ticket -> save();
    
            $pm_ticket = new pm_ticket();
            $pm_ticket -> description = $request -> description;
            $pm_ticket -> ticket_id = $ticket -> id;
            $pm_ticket -> client_id = $ticket -> client_id;
            $pm_ticket -> admin_id = $id_user;
            $pm_ticket -> type = 'admin';
            $pm_ticket -> save();
            if($request->file){
                $file = $request -> file -> getClientOriginalName();
                $pm_ticket -> file = $request -> file -> getClientOriginalName();
                $request -> file('file') -> move('upload/ticket', $file);
                $pm_ticket -> save();
            }


            $find_client = User::find($ticket -> client_id);
            $name_client = $find_client -> name;
            $phone_client = $find_client -> phone;




            $settings = settings::find(1);
            if($settings != null){
                $attributes = json_decode($settings->activation,true);
                if($attributes == true){
                    $send_sms_ticket_client = $attributes[0]['send_sms_ticket_client'];

                    if(($send_sms_ticket_client == 1) && ($find_client -> active_sms == 1)){// ارسال به نماینده
                        $text = 'به تیکت شما پاسخ داده شد';
                        $pm_sms = ' سلام ' . $name_client . ' عزیز '.PHP_EOL.
                        $text.PHP_EOL.
                        'شماره تیکت : '.$id.PHP_EOL.
                        'موضوع : '.$ticket -> title.PHP_EOL.
                        'نام سایت : '.$settings -> site_name;

                        $phone = $phone_client;
                        $new_send_sms = new sendSms();
                        $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                    }

                }
            }
            return back()->with('success','تیک با موفقیت ارسال شد');
        }
    }

}
