<?php

namespace App\Http\Controllers\portal;

use Cookie;
use Session;
use App\Models\User;
use App\Models\Transaction;
use Illuminate\Support\Str;
use App\Models\panel\factor;
use App\Models\panel\inform;
use Illuminate\Http\Request;
use App\Models\portal\portals;
use App\panelmodel\settings_ibsng;
use App\Http\Controllers\Controller;

class idpayController extends Controller
{


    public function add_order(Request $request)
    {
        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);

        $new_priceproduct = $cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];





        $response = $this->getToken($new_priceproduct * 10);

        if(isset($response->id) && !empty(isset($response->link))) {
            $transaction = Transaction::create([
                'amount' => $new_priceproduct * 10,
                'token'  => $response->id
            ]);
            return redirect($response->link);
        }
        else{
           return 'مشکلی پیش آمده است لطفا بعدا تلاش نمایید'; 
        }
        
    }

    public function callback(Request $request)
    {

        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);


        $new_priceproduct = $cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];



        if ($request->input('status') == 10) {

            $response = $this->curlPost('payment/verify', [
                'order_id' => $request->input('order_id'),
                'id' => $request->input('id'),
            ]);
            if($request->status && $request->status == '10'){
                $trans_id = $request -> track_id;

                $find_factor = factor::find($id_payfactor);
                $find_factor -> payment = 1;
                $find_factor -> transition_port = $trans_id;
                $find_factor -> save();


                // شروع اطلاع رسانی
                $id_client = $find_factor -> client_id;
                $send_name_factor = $find_factor -> text_factor;
                $send_price = $find_factor -> price;
                if($find_factor -> name_factor == "factorProduct"){
                    $set = "sms_order";
                }else{
                    $set = "sms_goods";
                }
                
                $new_inform = new inform();
                $sending = $new_inform -> sendSmsGoods($id_client,$send_name_factor,$send_price,$set);
                // پایان اطلاع رسانی


                return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
                
            }else{
                $find_factor = factor::find($id_payfactor);
                $find_factor -> payment = 2;
                $find_factor -> save();
                return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
            }
        }else{
            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 2;
            $find_factor -> save();
            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
        }
    }

    private function getToken($amount, $mobile = null, $factorNumber = null, $description = null)
    {
        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);

        $new_priceproduct = $cart_data['price'] * 10;
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];

        $find_factor = factor::find($id_payfactor);

        $order_id = Str::random(20);
        $response = $this->curlPost('payment', [
            'order_id' => $order_id,
            'amount' => $new_priceproduct * 10,
            'phone' => $phone,
            'name' => $find_factor -> name,
            'callback' => url('/idpayorder'),
        ]);
        
        return json_decode($response);
    }


    private function curlPost($method, $params)
    {
        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','idpay')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $idpay_code = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان

        $endpoint = 'https://api.idpay.ir/v1.1/';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint . $method);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            "X-API-KEY: {$idpay_code}",
        ]);

        $res = curl_exec($ch);
        curl_close($ch);

        return $res;
    }
}