<?php

namespace App\Http\Controllers\portal;

use Cookie;
use Session;
use App\Models\User;
use App\Models\Transaction;
use App\Models\panel\factor;
use App\Models\panel\inform;
use Illuminate\Http\Request;
use App\Models\portal\portals;
use App\Http\Controllers\Controller;

class payirController extends Controller
{
    
  public function add_order(Request $request)
  {


    $cookie_data = stripslashes(Cookie::get('pays_factor'));
    $cart_data = json_decode($cookie_data, true);


    $new_priceproduct = $cart_data['price'];
    $phone = $cart_data['phone'];
    $id_payfactor = $cart_data['factor'];


      $response = $this->getToken($new_priceproduct * 10);

      if(isset($response->status) && $response->status == '1') {
        $transaction = Transaction::create([
          'amount' => $new_priceproduct,
          'token'  => $response->token
        ]);

        return redirect('https://pay.ir/pg/' . $response->token);
      }
      return 'درگاه با دامنه همخوانی ندارد';
  }

  public function callback(Request $request)
  {

    $cookie_data = stripslashes(Cookie::get('pays_factor'));
    $cart_data = json_decode($cookie_data, true);


    $new_priceproduct = $cart_data['price'];
    $phone = $cart_data['phone'];
    $id_payfactor = $cart_data['factor'];

      
      if($request->status && $request->status == '1' && $request->token) {
        $transaction = Transaction::where('token', '=', $request->token)
          ->where('status', '!=', 1)
          ->where('verify_status', '!=', 1)
          ->first();

        if($transaction) {
          $response = $this->verify($transaction->token);
          if(isset($response->status) && $response->status == '1') {
            $transaction->update([
              'transaction_id' => $response->transId,
              'card_number'    => $response->cardNumber,
              'status'         => 1,
              'verify_status'  => 1
            ]);
            $trans_id = $response->transId;

            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 1;
            $find_factor -> transition_port = $trans_id;
            $find_factor -> save();

            // شروع اطلاع رسانی
            $id_client = $find_factor -> client_id;
            $send_name_factor = $find_factor -> text_factor;
            $send_price = $find_factor -> price;
            if($find_factor -> name_factor == "factorProduct"){
                $set = "sms_order";
            }else{
                $set = "sms_goods";
            }
            
            $new_inform = new inform();
            $sending = $new_inform -> sendSmsGoods($id_client,$send_name_factor,$send_price,$set);
            // پایان اطلاع رسانی

            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
          }
        }else{
          $find_factor = factor::find($id_payfactor);
          $find_factor -> payment = 2;
          $find_factor -> save();
          return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
        }
      }else{
        $find_factor = factor::find($id_payfactor);
        $find_factor -> payment = 2;
        $find_factor -> save();
        return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
      }
  }

  private function getToken($amount, $mobile = null, $factorNumber = null, $description = null) {

      // خواندن کد درگاه در دیتابیس شروع
      $portals = portals::where('portal','payir')->get();
      if($portals -> toArray() == []){
          return 'درگاه مورد نظر پیدا نشد';
      }
      $find_portals = $portals -> pluck('id')[0];
      $edit_portals = portals::find($find_portals);
      $json_data = json_decode($edit_portals -> data);
      $payir_code = $json_data -> code;
      // خواندن کد درگاه در دیتابیس پایان




    $response = $this->curlPost('https://pay.ir/pg/send', [
      'api'          => env('PAYIR_API_KEY', $payir_code),
      'amount'       => $amount,
      'redirect'     => url('/payir/callback'),
      'mobile'       => $mobile,
      'factorNumber' => $factorNumber,
      'description'  => $description,
    ]);
    return json_decode($response);
  }
  
  private function verify($token) {
      // خواندن کد درگاه در دیتابیس شروع
      $portals = portals::where('portal','payir')->get();
      if($portals -> toArray() == []){
          return 'درگاه مورد نظر پیدا نشد';
      }
      $find_portals = $portals -> pluck('id')[0];
      $edit_portals = portals::find($find_portals);
      $json_data = json_decode($edit_portals -> data);
      $payir_code = $json_data -> code;
      // خواندن کد درگاه در دیتابیس پایان



    $response = $this->curlPost('https://pay.ir/pg/verify', [
      'api' 	=> env('PAYIR_API_KEY', $payir_code),
      'token' => $token,
    ]);
    return json_decode($response);
  }
  
  private function curlPost($url, $params)
  {
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, [
          'Content-Type: application/json',
      ]);
      $res = curl_exec($ch);
      curl_close($ch);
  
      return $res;
  }
}
