<?php

namespace App\Http\Controllers\portal;

use Cookie;
use Session;
use App\Models\User;
use App\Models\Transaction;
use Kavenegar\KavenegarApi;
use App\Models\panel\factor;
use App\Models\panel\inform;
use Illuminate\Http\Request;
use App\Models\portal\portals;
use App\Http\Controllers\Controller;
use App\Models\sms\configurationSms;
use App\Models\sms\smsir\smsIr_sendMessage;



class paypingController extends Controller
{
  public function add_order(Request $request)
  {
      $cookie_data = stripslashes(Cookie::get('pays_factor'));
      $cart_data = json_decode($cookie_data, true);

      $new_priceproduct = $cart_data['price'];
      $phone = $cart_data['phone'];
      $id_payfactor = $cart_data['factor'];




      $amount = (int)$new_priceproduct;
      $response = $this->getToken($amount,$id_payfactor);
      if($response && $response->code && $response->code != ''){
        return redirect('https://api.payping.ir/v2/pay/gotoipg/' . $response->code);
      }else{
        return 'متاسفانه مشکلی پیش امده لطفا مجددا امتحان نمایید';
      }
  }

  public function callback(Request $request)
  {

    if($request && $request -> refid){
        $id_payfactor = $request -> clientrefid;
        $refid = $request -> refid;
        
        
        $find = factor::find($id_payfactor);
        $amount = $find -> price;
        $response = $this->verify($refid,$amount);
        if($response != false){

          $find_factor = factor::find($id_payfactor);
          $find_factor -> payment = 1;
          $find_factor -> transition_port = $refid;
          $find_factor -> save();



          // شروع اطلاع رسانی
          $id_client = $find_factor -> client_id;
          $send_name_factor = $find_factor -> text_factor;
          $send_price = $find_factor -> price;
          if($find_factor -> name_factor == "factorProduct"){
              $set = "sms_order";
          }else{
              $set = "sms_goods";
          }
          
          $new_inform = new inform();
          $sending = $new_inform -> sendSmsGoods($id_client,$send_name_factor,$send_price,$set);
          // پایان اطلاع رسانی


          return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));

        }else{
          $find_factor = factor::find($id_payfactor);
          $find_factor -> payment = 2;
          $find_factor -> save();
          return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
        }
    }else{
      $find_factor = factor::find($id_payfactor);
      $find_factor -> payment = 2;
      $find_factor -> save();
      return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
    }

  }

  private function getToken($amount,$id_payfactor) {
    $response = $this->curlPost('https://api.payping.ir/v2/pay', [
      'amount'=> $amount,
      'clientRefId'=> $id_payfactor,
      'returnUrl'=> url('/paypingorder'),
    ]);
    return json_decode($response);
  }

  
  private function verify($refid,$amount){
    $response = $this->curlPost('https://api.payping.ir/v2/pay/verify', [
      'refid' => $refid,
      "amount" => $amount,
    ]);
    return json_decode($response);
  }
  
  private function curlPost($url, $params)
  {

      // خواندن کد درگاه در دیتابیس شروع
      $portals = portals::where('portal','payping')->get();
      if($portals -> toArray() == []){
          return 'درگاه مورد نظر پیدا نشد';
      }
      $find_portals = $portals -> pluck('id')[0];
      $edit_portals = portals::find($find_portals);
      $json_data = json_decode($edit_portals -> data);
      $payir_code = $json_data -> code;
      // خواندن کد درگاه در دیتابیس پایان



      
      $token = $payping_code;
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "accept: application/json",
        "authorization: Bearer " . $token ,
        "cache-control: no-cache",
        "content-type: application/json",
      ]);
      $res = curl_exec($ch);
      $header = curl_getinfo($ch);
      $http_code = curl_getinfo($ch);
      if($http_code['http_code'] == 200){
        return $res;
      }else{
        return false;
      }

      
  }
}
