<?php

namespace App\Http\Controllers\portal;

use DB;
use Cookie;
use Session;
use nusoap_client;
use App\Models\User;
use App\Models\Transaction;
use App\Models\panel\factor;
use App\Models\panel\inform;
use Illuminate\Http\Request;
use App\Models\portal\portals;
use App\Http\Controllers\Controller;

class poolamController extends Controller
{
    public function add_order(Request $request)
    {

        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);

        $new_priceproduct = $cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];


        $amount = $new_priceproduct * 10;
        $callback = url('/poolamorder');


        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','poolam')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $poolam_code = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان


        $result = $this->request($poolam_code,$amount,urlencode($callback));
        $json_decode = json_decode($result);
        $status = $json_decode -> status;
        if($status == 1){
            $invoice_key = $json_decode -> invoice_key;
            $transaction = Transaction::create([
                'amount' => $amount,
                'token'  => $invoice_key
            ]);
            return redirect("https://poolam.ir/invoice/pay/".$invoice_key);
        }
        else{
           return 'مشکلی پیش آمده است لطفا بعدا تلاش نمایید'; 
        }
        
    }

    public function callback(Request $request)
    {

        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','poolam')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $poolam_code = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان

        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);

        $new_priceproduct = $cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];


        $all_request_array = $request->all();
        $invoice_key = $all_request_array['invoice_key'];
        $result = $this->check($poolam_code, $invoice_key);
        $json_decode = json_decode($result);
        $status = $json_decode -> status;
        if($status == 1){
            $trans_id = $json_decode -> bank_code;

            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 1;
            $find_factor -> transition_port = $trans_id;
            $find_factor -> save();



                // شروع اطلاع رسانی
                $id_client = $find_factor -> client_id;
                $send_name_factor = $find_factor -> text_factor;
                $send_price = $find_factor -> price;
                if($find_factor -> name_factor == "factorProduct"){
                    $set = "sms_order";
                }else{
                    $set = "sms_goods";
                }
                
                $new_inform = new inform();
                $sending = $new_inform -> sendSmsGoods($id_client,$send_name_factor,$send_price,$set);
                // پایان اطلاع رسانی


            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));

        }else{
            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 2;
            $find_factor -> save();
            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
        }
    }

    private function request($pal_code,$amount,$redirect)
    {
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://poolam.ir/invoice/request');
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$pal_code&amount=$amount&return_url=$redirect");
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
    function check($pal_code,$inv_key){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://poolam.ir/invoice/check/'.$inv_key);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$pal_code");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
}
