<?php

namespace App\Http\Controllers\portal;

use DB;
use Cookie;
use Session;
use nusoap_client;
use App\Models\User;
use App\Models\panel\factor;
use App\Models\panel\inform;


use Illuminate\Http\Request;
use App\Models\portal\portals;
use App\Http\Controllers\Controller;

class vandarController extends Controller
{
    
    public function add_order(Request $request)
    {
        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);

        
        $new_priceproduct = (int)$cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];
        $name_user = $cart_data['name_user'];
        $email = $cart_data['email'];

        $find_factor = factor::find($id_payfactor);
        $name = $find_factor-> name;

        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','vandar')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $vandar_code = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان


        $params = array(
            'api_key' => $vandar_code,
            'amount' => $new_priceproduct * 10,
            'mobile_number' => $phone,
            'name' => $find_factor -> name,
            'factorNumber' => (string)$find_factor -> id,
            'callback_url' => url('/vandarorder'),
        );
        $urlvendar = 'https://ipg.vandar.io/api/v4/send';



        $response = $this->getToken($params,$urlvendar);
        $json_decode = json_decode($response);
        if($json_decode -> status == 1){
            return redirect('https://ipg.vandar.io/v4'.'/'.$json_decode->token);
        }else{
            return back()->with('error','مشکلی در موقع اتصال به درگاه پیش آماده لطفا مجددا تلاش نمایید');
        }
    }





    public function callback(Request $request)
    {

        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);


        $new_priceproduct = $cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];

        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','vandar')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $vandar_code = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان


        $params = array(
            'api_key' => $vandar_code,
            'token' => $request ->  token,
        );
        $urlvendar = 'https://ipg.vandar.io/api/v4/verify';

        $response = $this->getToken($params,$urlvendar);
        $json_decode = json_decode($response);
        if ($json_decode -> status == 1) {
            $trans_id = $json_decode -> transId;
            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 1;
            $find_factor -> transition_port = $trans_id;
            $find_factor -> save();



            // شروع اطلاع رسانی
            $id_client = $find_factor -> client_id;
            $send_name_factor = $find_factor -> text_factor;
            $send_price = $find_factor -> price;
            if($find_factor -> name_factor == "factorProduct"){
                $set = "sms_order";
            }else{
                $set = "sms_goods";
            }
            
            $new_inform = new inform();
            $sending = $new_inform -> sendSmsGoods($id_client,$send_name_factor,$send_price,$set);
            // پایان اطلاع رسانی


            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
        }else{
            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 2;
            $find_factor -> save();
            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));
        }
    }

    private function getToken($params,$urlvendar)
    {
        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','vandar')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $vandar_code = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان

        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $urlvendar);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);

        $res = curl_exec($ch);
        curl_close($ch);

        return $res;
    }

}
