<?php

namespace App\Http\Controllers\portal;

use Cookie;
use Session;
use App\Models\User;
use App\Models\panel\factor;
use App\Models\panel\inform;
use Illuminate\Http\Request;
use App\Models\portal\portals;
use App\Http\Controllers\Controller;

class zibalController extends Controller
{
    public function add_order(Request $request)
    {
        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);
    
        $new_priceproduct = $cart_data['price'];
        $mobile = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];
        $orderId = $id_payfactor;
        $callback = url('/zibalorder');



        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','zibal')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $merchant = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان



        $amount = (int)$new_priceproduct * 10;

        $parameters = array(
            "merchant"=> $merchant,//required
            "callbackUrl"=> $callback,//required
            "amount"=> $amount,//required
            "orderId"=> $orderId,//optional
            "mobile"=> $mobile,//optional
        );
        
        $response = $this->postToZibal('request', $parameters);
        if($response -> result == 100){
          return redirect('https://gateway.zibal.ir/start/' . $response->trackId);
        }else{
          return 'متاسفانه مشکلی پیش امده لطفا مجددا امتحان نمایید';
        }
    }




    public function callback(Request $request)
    {
        // خواندن کد درگاه در دیتابیس شروع
        $portals = portals::where('portal','zibal')->get();
        if($portals -> toArray() == []){
            return 'درگاه مورد نظر پیدا نشد';
        }
        $find_portals = $portals -> pluck('id')[0];
        $edit_portals = portals::find($find_portals);
        $json_data = json_decode($edit_portals -> data);
        $merchant = $json_data -> code;
        // خواندن کد درگاه در دیتابیس پایان

        $cookie_data = stripslashes(Cookie::get('pays_factor'));
        $cart_data = json_decode($cookie_data, true);


        $new_priceproduct = $cart_data['price'];
        $phone = $cart_data['phone'];
        $id_payfactor = $cart_data['factor'];


        $all_request_array = $request->all();
        $success = $all_request_array['success'];
        $trackId = $all_request_array['trackId'];
        if($success == 1){
            //start verfication
            $parameters = array(
                "merchant" => $merchant,//required
                "trackId" => $trackId,//required

            );

            $response = $this->postToZibal('verify', $parameters);
            if ($response->result == 100) {

                $find_factor = factor::find($id_payfactor);
                $find_factor -> payment = 1;
                $find_factor -> transition_port = $trackId;
                $find_factor -> save();



                // شروع اطلاع رسانی
                $id_client = $find_factor -> client_id;
                $send_name_factor = $find_factor -> text_factor;
                $send_price = $find_factor -> price;
                if($find_factor -> name_factor == "factorProduct"){
                    $set = "sms_order";
                }else{
                    $set = "sms_goods";
                }
                
                $new_inform = new inform();
                $sending = $new_inform -> sendSmsGoods($id_client,$send_name_factor,$send_price,$set);
                // پایان اطلاع رسانی


                return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));

            }else{
                $find_factor = factor::find($id_payfactor);
                $find_factor -> payment = 2;
                $find_factor -> save();
                return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));   
            }
        }else{
            $find_factor = factor::find($id_payfactor);
            $find_factor -> payment = 2;
            $find_factor -> save();
            return redirect('client/factor'.'/'. $find_factor -> id)->withCookie(Cookie::forget('pays_factor'));   
        }

    }









    function postToZibal($path, $parameters)
    {
        $url = 'https://gateway.zibal.ir/v1/'.$path;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($parameters));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response  = curl_exec($ch);
        curl_close($ch);
        return json_decode($response);
    }

}
