<?php

namespace App\Models\panel;

use Verta;
use App\Models\User;
use App\Models\panel\factor;
use Illuminate\Support\Facades\DB;
use App\Models\panel\category_campaign;
use Illuminate\Database\Eloquent\Model;

class campaign extends Model
{
    protected $table = 'campaign';

    public function getCreatedAtAttribute($value)
    {
        //return Carbon::parse($value)->format('Y-m-d H:i:s');
        return Verta::instance($value)->format('Y-m-d H:i:s');
    }


    public function getNameCategoryAttribute()
    {
        $id_Category = $this->attributes['id_category'];
        $find_Category = category_campaign::find($id_Category);
        if($find_Category != null){
            return $find_Category -> name;
        }else{
            return "-";
        }
    }

    public function getArrayFactorAttribute()
    {
        $id_campaign = $this->attributes['id'];
        $campaignPrice = $this->attributes['price'];

        /*
        $get_factor = factor::where('name_factor','factorCampaign')
        ->where('campaign_id',$id_campaign)
        ->whereJsonContains('items_factor', ['id_campaign' => $id_campaign])
        ->where('payment',1)->get();
        */


        $baseQuery = factor::where('name_factor', 'factorCampaign')
            ->where('payment', 1)
            ->where('campaign_id', $id_campaign);


        $totalCollected = (int) (clone $baseQuery)->sum('price');
        $supportersCount = (int) (clone $baseQuery)
            ->distinct('client_id')
            ->count('client_id');
        $remainingAmount = max($campaignPrice - $totalCollected, 0);
        // درصد پیشرفت کمپین
        $progressPercent = $campaignPrice > 0
            ? round(($totalCollected / $campaignPrice) * 100, 2)
            : 0;


        $topSupporters = factor::select(
            'client_id',
            DB::raw('SUM(price) as total_paid')
        )
        ->where('name_factor', 'factorCampaign')
        ->where('payment', 1)
        ->where('campaign_id', $id_campaign)
        ->groupBy('client_id')
        ->orderByDesc('total_paid')
        ->limit(5)
        ->with('user') // فیلدهایی که لازم داری
        ->get();





        return [
            'TotalCollected'   => $totalCollected,
            'SupportersCount'  => $supportersCount,
            'RemainingAmount'  => $remainingAmount,
            'ProgressPercent'  => $progressPercent,
            'TopSupporters'  => $topSupporters,
        ];
    }





    protected $appends = ['name_category','array_factor'];




}
