<?php

namespace App\Models\panel;

use Verta;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class pm_ticket extends Model
{
    use HasFactory;

    protected $table = 'pm_ticket';


    public function getCreatedAtAttribute($value)
    {
        //return Carbon::parse($value)->format('Y-m-d H:i:s');
        return Verta::instance($value)->format('Y-m-d H:i:s');
    }


    public function getNameUserAttribute()
    {
        $type = $this->attributes['type'];
        $reseller_id = $this->attributes['reseller_id'];
        $admin_id = $this->attributes['admin_id'];

        if ($type == "reseller") {
            $reseller_id = User::find($reseller_id);
            if($reseller_id != null){
                $name = $reseller_id -> name ;
                return $name;
            }else{
                 $admin_id = User::find($admin_id);
                if($admin_id != null){
                    $name = $admin_id -> name ;
                    return $name;
                }else{
                    return "-";
                }

            }

        }
    }


    public function getImageUserAttribute()
    {
        $type = $this->attributes['type'];
        $reseller_id = $this->attributes['reseller_id'];
        $admin_id = $this->attributes['admin_id'];

        if ($type == "reseller") {
            $reseller_id = User::find($reseller_id);
            if($reseller_id != null){
                $avatar = $reseller_id -> avatar ;
                return $avatar;
            }else{
                 $admin_id = User::find($admin_id);
                if($admin_id != null){
                    $avatar = $admin_id -> avatar ;
                    return $avatar;
                }else{
                    return "-";
                }

            }

        }
    }
    public function getDateAgoAttribute()
    {
        $type = $this->attributes['created_at'];
        $varta = new \Verta($type);
        $time = $varta ->formatDifference();
        return $time;
    }

    protected $appends = ['name_user','image_user','date_ago'];
}
