<?php

namespace App\Models\panel\sms;

use Kavenegar\KavenegarApi;
use Melipayamak\MelipayamakApi;
use Illuminate\Database\Eloquent\Model;
use App\Models\panel\sms\ippanel\ippanel;
use App\Models\panel\sms\configurationSms;
use App\Models\panel\sms\smsir\smsIr_sendMessage;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class sendSms extends Model
{
    use HasFactory;

    public function sendSms($pm_sms,$phone,$panel_sms){
        $configurationSms = configurationSms::find($panel_sms);
        if(($configurationSms != null)){
            $json_data = json_decode($configurationSms -> data);

            if(($configurationSms -> active == 1) && ($configurationSms -> name == "smsir")){
                $APIKEY = $json_data -> APIKEY;
                $LineNumber = $json_data -> phone;
                $SendDateTime = date("Y-m-d")."T".date("H:i:s");
                
                if(is_array($phone)){
                    $MobileNumbers = $phone;
                }else{
                    $MobileNumbers = array($phone);
                }
                
                $Messages = array($pm_sms);
                $SmsIR_SendMessage = new smsIr_sendMessage();
                $SendMessage = $SmsIR_SendMessage->NewSendMessage($APIKEY,$pm_sms,$LineNumber,$MobileNumbers);
                return [
                    "status" => 1,
                ];
            }elseif(($configurationSms -> active == 1) && ($configurationSms -> name == "kavenegar")){
                $username = $json_data -> username;
                $phone_send = $json_data -> phone;
                $api = new KavenegarApi($username);
                $sender = $phone_send;

                if(is_array($phone)){
                    $receptor = $phone;
                }else{
                    $receptor = array($phone);
                }

                $result = $api->Send($sender,$receptor,$pm_sms);
                return [
                    "status" => 1,
                ];
            }elseif(($configurationSms -> active == 1) && ($configurationSms -> name == "melipayamak")){
                $username = $json_data -> username;
                $password = $json_data -> password;
                $send_phone = $json_data -> phone;

                $api = new MelipayamakApi($username,$password);
                $sms = $api->sms('soap');

                if(is_array($phone)){
                    $to = $phone;
                }else{
                    $to = array($phone);
                }

                $from = $send_phone;
                $text = $pm_sms;
                $isFlash = false;
                $json = $sms->send($to,$from,$text,$isFlash);
                return [
                    "status" => 1,
                ];
            }elseif(($configurationSms -> active == 1) && ($configurationSms -> name == "ippanel")){
                $uname = $json_data -> username;
                $pass = $json_data -> password;
                $from = $json_data -> phone;

                if(is_array($phone)){
                    $MobileNumbers = $phone;
                }else{
                    $MobileNumbers = array($phone);
                }
                
                $ippanel = new ippanel();
                $sendingSms = $ippanel -> sendingSms($uname,$pass,$from,$pm_sms,$MobileNumbers);
                if($sendingSms["status"] == 0){
                    return [
                        "status" => 1,
                    ];
                }else{
                    return [
                        "status" => 2,
                    ];
                }
            }
            
            else{
                return [
                    "status" => 2,
                ];
            }
            return [
                "status" => 1,
            ];
        }else{
            return [
                "status" => 2,
            ];
        }
    }









}
