<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('address_home', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('name_receiver');// نام گیرنده
            $table->string('phone_receiver');// شماره موبایل گیرنده
            $table->text('address');// آدرس دقیق
            $table->string('postal_code');// کد پستی
            $table->bigInteger('client_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('address_home');
    }
};
