@extends('layouts.panel.headerLogin')
@section('title', 'ثبت نام')
@section('content')
    <!--begin::Login Sign in form-->

	<div class="w-md-400px">

		<form class="form w-100" novalidate="novalidate" method="POST" action="{{ url('registerClient') }}">
			{{ csrf_field() }}    
			<div class="text-center mb-11">
				<h1 class="text-dark fw-bolder mb-3">ثبت نام</h1>
				<div class="text-gray-500 fw-semibold fs-6">پنل کاربری شما</div>
			</div>

			<div class="separator separator-content my-14">
				<span class="w-125px text-gray-500 fw-semibold fs-7">فیلد های ثبت نام</span>
			</div>


			<div class="fv-row mb-3">
				<input type="text"  name="name" value="{{ old('name') }}" placeholder="نام و نام خانوادگی : " autocomplete="off" class="form-control bg-transparent" required/>
			</div>

			<div class="fv-row mb-3">
				<input type="text"  name="phone" value="{{ old('phone') }}" placeholder="شماره موبایل : " autocomplete="off" class="form-control bg-transparent" required/>
			</div>

			<div class="fv-row mb-3">
				<input  type="email" value="{{ old('email') }}"  name="email" placeholder="ایمیل : " autocomplete="off" class="form-control bg-transparent" required/>
			</div>

			<div class="fv-row mb-3">
				<input  type="password"  name="password" placeholder="کلمه عبور  : "  autocomplete="off" class="form-control bg-transparent" required />
			</div>

			<div class="fv-row mb-3">
				<input  type="password"  name="password_confirmation" placeholder="تکرار کلمه عبور : "  autocomplete="off" class="form-control bg-transparent" required />
			</div>

			<div class="fv-row mb-3">
				<input style="direction: ltr;"   type="test" id="captcha" name="captcha" type="text" placeholder="code : "  autocomplete="off" class="form-control bg-transparent" />
			</div>

			<div style="display:flex;justify-content: space-between;margin-bottom:10px">
				<div type="button" class="btn btn-warning bt-chaptcha" id="kt_btn_1">
					بارگذاری مجدد
				</div>
				<img id="images_captacha" src="{{ captcha_src() }}" alt="images_captacha" />
			</div>


			<div class="d-grid mb-10">
				<button type="submit" class="btn btn-primary">
					<span class="indicator-label">ثبت نام</span>
					<span class="indicator-progress"> صبر کنید...
					<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
				</button>
			</div>

			<div class="text-gray-500 text-center fw-semibold fs-6">حساب کاربری دارید ؟ 
			<a href="{{ route('login') }}" class="link-primary">ورود</a></div>
		</form>

	</div>

    <!--end::Login Sign in form-->
@endsection
