﻿@extends('layouts/client/header')
@section('title', 'همه آدرس ها')
@section('content')
@php
	use App\Models\user;
@endphp
<div class="col-lg-12">
	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h3 class="card-label">
					همه آدرس ها
				</h3>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>ID</th>
						<th>نام کاربر</th>
						<th>نام گیرنده</th>
						<th>شماره موبایل گیرنده</th>
						<th>کد پستی</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($AddressHome as $item_AddressHome)
						<tr>
							<td>#{{ $item_AddressHome->id }}</td>
							<td>{{ $item_AddressHome->client_name }}</td>
							<td>{{ $item_AddressHome->name_receiver }}</td>
							<td>{{ $item_AddressHome->phone_receiver }}</td>
							<td>{{ $item_AddressHome->postal_code }}</td>


							<td class="delete-content">
								<a href="{{ url('client/editAddressHome') . '/' . $item_AddressHome->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="ویرایش">
									<span class=""> <svg xmlns="http://www.w3.org/2000/svg"
											xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
											viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"></rect>
												<path fill="currentColor"
													d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z"
													fill="#000000" fill-rule="nonzero"
													transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) ">
												</path>
												<rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2"
													rx="1"></rect>
											</g>
										</svg> </span>
								</a>
							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
		<div>
			{{ $AddressHome->links('layouts.others.pagination') }}
		</div>
	</div>
</div>

@endsection
