﻿@extends('layouts/client/header')
@section('title', "$campaign->name")
@section('content')
<style>



</style>
@php
	$ProgressPercent = $campaign->array_factor['ProgressPercent'];
	if($ProgressPercent <= 40){
		$background = 'bg-danger';
		$text = 'در حال جمع آوری';
		$background_span = 'primary';
	}elseif($ProgressPercent <= 99){
		$background = 'bg-primary';
		$text = 'در حال جمع آوری';
		$background_span = 'primary';
	}else{
		$background = 'bg-success';
		$text = 'موفق';
		$background_span = 'success';
	}
@endphp

	<div class="col-lg-12">
		<div class="card card-custom gutter-b  example-compact">
			<div class="card-header row">

				<h3 class="card-title col-lg-8" style="width: auto;">
					{{$campaign->name}}
				</h3>

				<div class="col-lg-4" style="margin-top: 18px;">
					<div class="d-flex justify-content-between fw-bold fs-6 text-gray-400 w-100 mt-auto mb-2">
						<span>پیشرفت</span>
						<span>{{$ProgressPercent}}%</span>
					</div>
					<!--  bg-success  bg-danger   -->
					<div class="h-4px w-100 bg-light mb-5" data-bs-toggle="tooltip" aria-label="This project {{$ProgressPercent}}% completed" data-bs-original-title="This project 50% completed" data-kt-initialized="1">

						<div class="{{$background}} rounded h-4px" role="progressbar" style="width: {{$ProgressPercent}}%" aria-valuenow="{{$ProgressPercent}}" aria-valuemin="0" aria-valuemax="100"></div>
					</div>
				</div>

			</div>
			<!--begin::Form-->
			<form class="form-horizontal" method="POST" action="{{ url('client/crateFactorCampaign'.'/'.$campaign->id) }}" enctype="multipart/form-data">
				{{ csrf_field() }}
				<div class="card-body pad-top-0">
					<div style="width: 100%;display: flex;flex-direction: column;">
						<img src="{{url("upload/Campaign")."/". $campaign->image}}" alt="image" style="width:50%;margin: 0 auto;margin-bottom: 20px;border-radius: 15px !important;">
					</div>
					<ul class="nav nav-pills nav-pills-custom mb-3" role="tablist" style="display: flex;justify-content: center;">

						<!--begin::item-->
						<li class="nav-item mb-3 me-3 me-lg-6">
							<!--begin::Link-->
							<a class="nav-link d-flex justify-content-between flex-column flex-center overflow-hidden py-4" style="width: 200px">
								<!--begin::Icon-->
								<div class="nav-icon mb-3">
									<img style="width:50px;" src="{{ URL::asset('assets/panel/media/profit.png')}}" class="">
								</div>
								<!--end::Icon-->
								<!--begin::Subtitle-->
								<span class="nav-text text-gray-700 fw-bold fs-6 lh-1 mb-3">مبلغ جمع آوری شده</span>
								<!--end::Subtitle-->
								<!--begin::Bullet-->
								<span class="">{{number_format($campaign->array_factor['TotalCollected'])}} تومان</span>
								<!--end::Bullet-->
							</a>
							<!--end::Link-->
						</li>
						<!--end::item-->



						<!--begin::item-->
						<li class="nav-item mb-3 me-3 me-lg-6">
							<!--begin::Link-->
							<a class="nav-link d-flex justify-content-between flex-column flex-center overflow-hidden py-4" style="width: 200px">
								<!--begin::Icon-->
								<div class="nav-icon mb-3">
									<img style="width:50px;" src="{{ URL::asset('assets/panel/media/price-tag.png')}}" class="">
								</div>
								<!--end::Icon-->
								<!--begin::Subtitle-->
								<span class="nav-text text-gray-700 fw-bold fs-6 lh-1 mb-3">مبلغ کل هدف</span>
								<!--end::Subtitle-->
								<!--begin::Bullet-->
								<span class="">{{number_format($campaign->price)}} تومان</span>
								<!--end::Bullet-->
							</a>
							<!--end::Link-->
						</li>
						<!--end::item-->





						<!--begin::item-->
						<li class="nav-item mb-3 me-3 me-lg-6">
							<!--begin::Link-->
							<a class="nav-link d-flex justify-content-between flex-column flex-center overflow-hidden py-4" style="width: 200px">
								<!--begin::Icon-->
								<div class="nav-icon mb-3">
									<img style="width:50px;" src="{{ URL::asset('assets/panel/media/discount.png')}}" class="">
								</div>
								<!--end::Icon-->
								<!--begin::Subtitle-->
								<span class="nav-text text-gray-700 fw-bold fs-6 lh-1 mb-3">مبلغ باقی مانده</span>
								<!--end::Subtitle-->
								<!--begin::Bullet-->
								<span class="">{{number_format($campaign->array_factor['RemainingAmount'])}} تومان</span>
								<!--end::Bullet-->
							</a>
							<!--end::Link-->
						</li>
						<!--end::item-->





						<!--begin::item-->
						<li class="nav-item mb-3 me-3 me-lg-6">
							<!--begin::Link-->
							<a class="nav-link d-flex justify-content-between flex-column flex-center overflow-hidden py-4" style="width: 200px">
								<!--begin::Icon-->
								<div class="nav-icon mb-3">
									<img style="width:50px;" src="{{ URL::asset('assets/panel/media/svg/avatars/001-boy.svg')}}" class="">
								</div>
								<!--end::Icon-->
								<!--begin::Subtitle-->
								<span class="nav-text text-gray-700 fw-bold fs-6 lh-1 mb-3">تعداد حامیان</span>
								<!--end::Subtitle-->
								<!--begin::Bullet-->
								<span class="">{{number_format($campaign->array_factor['SupportersCount'])}} عدد</span>
								<!--end::Bullet-->
							</a>
							<!--end::Link-->
						</li>
						<!--end::item-->


						<!--begin::item-->
						<li class="nav-item mb-3 me-3 me-lg-6">
							<!--begin::Link-->
							<a class="nav-link d-flex justify-content-between flex-column flex-center overflow-hidden py-4" style="width: 200px">
								<!--begin::Icon-->
								<div class="nav-icon mb-3">
									<img style="width:50px;" src="{{ URL::asset('assets/panel/media/calendar.png')}}" class="">
								</div>
								<!--end::Icon-->
								<!--begin::Subtitle-->
								<span class="nav-text text-gray-700 fw-bold fs-6 lh-1 mb-3">تاریخ ثبت</span>
								<!--end::Subtitle-->
								<!--begin::Bullet-->
								<span class="">{{$campaign -> created_at}}</span>
								<!--end::Bullet-->
							</a>
							<!--end::Link-->
						</li>
						<!--end::item-->

						
					</ul>


						<div class="col-lg-12 form-group mb-3" >
							<div class="symbol-group symbol-hover justify-content-center">
								@foreach ($campaign->array_factor['TopSupporters'] as $item_TopSupporters)
									<div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip" aria-label="{{$item_TopSupporters->user->name}}" data-bs-original-title="{{$item_TopSupporters->user->name}}" data-kt-initialized="{{$item_TopSupporters->user->id}}">
										<img alt="Pic" src="{{url('upload'.'/'.$item_TopSupporters->user -> avatar)}}">
									</div>
								@endforeach
								<div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip" data-bs-original-title="+{{number_format($campaign->array_factor['SupportersCount'])}}" data-kt-initialized="1" aria-describedby="tooltip285458">
									<span class="symbol-label bg-dark text-inverse-dark fw-bold">+{{number_format($campaign->array_factor['SupportersCount'])}}</span>
								</div>
							</div>

						</div>    






					<div class="separator my-6"></div>
					<div>
						{!! html_entity_decode($campaign -> description) !!}
					</div>
					<div class="separator my-6"></div>

					<div class="row">
						<div class="col-lg-12 form-group mb-3">
							<label class="mb-3">مبلغ حمایت ( تومان )</label>
							<input id="price" type="number" class="form-control" name="price" placeholder="مبلغ حمایت ( تومان )" required>
						</div>    
					</div>




            
				</div>
				<div class="card-footer">
					<button class="btn btn-primary mr-2">ثبت</button>
					<a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
				</div>
			</form>
			<!--end::Form-->
		</div>
	</div>





@endsection
