﻿@extends('layouts/client/header')
@section('title', 'همه فاکتور پرداخت نشده ها')
@section('content')
@php
	use Hekmatinasser\Verta\Verta;
	use App\Models\portal\portals;
@endphp


<div class="col-lg-12">


	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h5 class="card-label">
					همه فاکتور پرداخت نشده ها
				</h5>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>شماره فاکتور</th>
						<th>نام و نام خانوادگی</th>
						<th>نام فاکتور</th>
						<th>شماره موبایل</th>
						<th>مبلغ پرداخت</th>
						<th>درگاه</th>
						<th>وضعیت</th>
						<th>تاریخ صدور فاکتور</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($factor as $item_charge_wallet)
						<tr>
							<td>{{$item_charge_wallet->id}} #</td>
							<td>{{$item_charge_wallet->array_user->name}}</td>
							<td>
								{{$item_charge_wallet -> text_factor}}
							</td>
							<td>{{$item_charge_wallet->array_user->phone}}</td>
							<td>{{ number_format($item_charge_wallet->price) }} تومان</td>
							<td>
								<span class="badge badge-light-warning nback">{{ $item_charge_wallet -> name_banks }}</span>
							</td> 
							<td>
								@if($item_charge_wallet->payment == 0)
									<span class="badge badge-light-warning nback">پرداخت نشده</span>
								@elseif($item_charge_wallet->payment == 1)
									<span class="badge badge-light-success nback">پرداخت شده</span>
								@elseif($item_charge_wallet->payment == 3)
									<span class="badge badge-light-danger nback">پس داده شده</span>
								@else
									<span class="badge badge-light-danger nback">لغو شده</span>
								@endif
							</td>
							
							<td>
								{{$item_charge_wallet -> created_at}}
							</td>
							<td class="delete-content">
								<a href="{{ url('client/factor') . '/' . $item_charge_wallet->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="نمایش">
									<span>
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"/>
												<path d="M13,5 L15,5 L15,20 L13,20 L13,5 Z M5,5 L5,20 L3,20 C2.44771525,20 2,19.5522847 2,19 L2,6 C2,5.44771525 2.44771525,5 3,5 L5,5 Z M16,5 L18,5 L18,20 L16,20 L16,5 Z M20,5 L21,5 C21.5522847,5 22,5.44771525 22,6 L22,19 C22,19.5522847 21.5522847,20 21,20 L20,20 L20,5 Z" fill="#000000"/>
												<polygon fill="#000000" opacity="0.3" points="9 5 9 20 7 20 7 5"/>
											</g>
										</svg>
									</span>
								</a>


							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
		<div>
			{{ $factor->links('layouts.others.pagination') }}
		</div>
	</div>
</div>





@endsection
