@extends('layouts/client/header')
@section('title', 'همه خبر ها')
@section('content')
<div class="col-lg-12">
	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h5 class="card-label">
					همه خبر ها
				</h5>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>عنوان اخبار</th> 
						<th>توضیحات</th> 
						<th>تاریخ</th> 
						<th>عملیات</th> 
					</tr>
				</thead>
				<tbody>
					@foreach ($all_user as $item_news)
						<tr>
							<td>{{$item_news -> title}}</td> 
							<td>{{\Illuminate\Support\Str::limit($item_news -> description, 30)}}</td> 
							<td>
								@php
									$varta = Verta($item_news -> created_at);
									echo $varta;    
								@endphp
							</td>
							<td>
								<a href='news/{{$item_news -> id}}' class="btn btn-info mr-2">مشاهده اخبار</a>
							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
		<div>
			{{ $all_user->links('layouts.others.pagination') }}
		</div>
	</div>
</div>


@endsection
