﻿@extends('layouts/client/header')
@section('title', 'سبد خرید')
@section('content')

<div class="row g-5 g-xl-10 mb-5 mb-xl-10">
	<div class="col-lg-12">


		<div class="card card-custom table-responsive">
			<div class="card-header flex-wrap ">
				<div class="card-title">
					<h5 class="card-label">
					سبد خرید
					</h5>
				</div>
			</div>
			<div class="card-body pad-top-0">
				@if ($allCarts -> count() >= 1)
					

				<!--begin: جدول داده ها-->
				<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
					<thead>
						<tr>
							<th>عکس محصول</th>
							<th>نام محصول</th>
							<th>تعداد</th>
							<th>مبلغ واحد</th>
							<th>مبلغ کل</th>
							<th>عملیات</th>
						</tr>
					</thead>
					<tbody>
						@foreach ($allCarts as $item_allCarts)
							<tr>
								<td><img src="{{url("upload/Product")."/". $item_allCarts->array_product->image}}" alt="image" class="p-3" style="width:100px;"></td>
								<td>{{$item_allCarts->array_product->name}}</td>
								<td>{{$item_allCarts->quantity}} عدد</td>
								<td>{{ number_format($item_allCarts->array_product->price) }} تومان</td>
								<td>{{ number_format($item_allCarts->array_product->price * $item_allCarts->quantity) }} تومان</td>
								<td class="delete-content">
									<div class="quantity-box">
										<button class="btn btn-danger" onclick="decrease({{ $item_allCarts->array_product->id }})">-</button>
										<span class="fw-bold fs-3 text-dark" style="padding: 15px;" id="qty-{{ $item_allCarts->array_product->id }}">{{ $item_allCarts->quantity }}</span>
										<button class="btn btn-success" onclick="increase({{ $item_allCarts->array_product->id }})">+</button>
									</div>
								</td>
							</tr>
						@endforeach

					</tbody>

				</table>
				<!--end: جدول داده ها-->
				@else
				<div style="display: flex;flex-direction: column;align-items: center;">
					<img style="width:150px;" src="{{ URL::asset('assets/panel/media/shopping.png')}}" class="">
					<p class="fs-3 text-dark">سبد خرید شما خالی است</p>
				</div>
				@endif

			</div>
		</div>
	</div>


	@if ($allCarts -> count() >= 1)
	<div class="col-lg-12">
		<div class="card card-custom table-responsive">
			<div class="card-header flex-wrap ">
				<div class="card-title">
					<h5 class="card-label">
						تکمیل سفارش
					</h5>
				</div>
			</div>
			<div class="card-body pad-top-0">
				<form class="form-horizontal" method="POST" action="{{ url('client/createFactorCart') }}">
					{{ csrf_field() }}
					<div class="row">
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">انتخاب آدرس</label>
							<!--begin::انتخاب-->
							<select name="address" data-control="select2" data-placeholder="انتخاب آدرس" class="form-select form-select-solid" required>
								<option value="">انتخاب آدرس</option>
								@foreach ($AddressHome as $item_AddressHome)
									<option value="{{$item_AddressHome -> id}}">{{$item_AddressHome -> title}}</option>
								@endforeach
							</select>
							<!--end::انتخاب-->
						</div>
						<div class="col-lg-6 form-group mb-3">
							@php
								$totalPrice = 0;
								foreach ($allCarts as $cart) {
									if ($cart->array_product != "-") {
										$totalPrice += $cart->array_product->price * $cart->quantity;
									}
								}
							@endphp


							<div class="fs-3 text-dark" style="padding: 0px 0px 10px 0px;display: flex;justify-content: space-between;">
								<spa>مبلغ قابل پرداخت :</spa>
								<spa>{{number_format($totalPrice)}} تومان</spa>
							</div>
							<div class="card-footer" style="padding: 10px 0px 0px 0px;">
								<button class="btn btn-primary mr-2" style="float: left;">ثبت سفارش</button>
							</div>

						</div>
					</div>
				</form>


			</div>
		</div>
	</div>

	@endif








</div>


























	@section('script')
			<script>
				function addToCart(productId) {
					fetch("{{ url('client/addCart') }}", {
						method: "POST",
						headers: {
							"X-CSRF-TOKEN": "{{ csrf_token() }}",
							"Content-Type": "application/json"
						},
						body: JSON.stringify({ product_id: productId })
					}).then(() => location.reload());
				}

				function increase(productId) {
					fetch("{{ url('client/cartIncrease') }}", {
						method: "POST",
						headers: {
							"X-CSRF-TOKEN": "{{ csrf_token() }}",
							"Content-Type": "application/json"
						},
						body: JSON.stringify({ product_id: productId })
					}).then(() => location.reload());
				}

				function decrease(productId) {
					fetch("{{ url('client/cartDecrease') }}", {
						method: "POST",
						headers: {
							"X-CSRF-TOKEN": "{{ csrf_token() }}",
							"Content-Type": "application/json"
						},
						body: JSON.stringify({ product_id: productId })
					}).then(() => location.reload());
				}
			</script>
	@endsection



@endsection
