﻿@extends('layouts/client/header')
@section('title', 'همه دسته بندی محصول ها')
@section('content')

<style>
.border-hover-primary {
    border: 1px solid white;
}
.border-hover-primary:hover {
    border-color: var(--bs-primary) !important;
}
</style>
@php
	use App\Models\panel\carts;
@endphp


<div class="row">



	<div class="col-lg-2 col-xl-2 col-xxl-2 mb-5 mb-xl-0 card">
		@foreach($CategoryProduct as $item_CategoryProduct)
			<a href="{{url('client/searchCategoryProduct'.'/'.$item_CategoryProduct -> id)}}">
				<div class="card-header border-0 pt-5">
					<h3 class="card-title align-items-start flex-column">
						<span class="card-label fw-bold text-dark">دسته بندی ها</span>
						<span class="text-muted mt-1 fw-semibold fs-7">کل محصول های فعال ( {{$count_Productok}} عدد )</span>
					</h3>
				</div>
				<div class="card-body pt-7 px-0">
					<div class="tab-content mb-2 px-9">
						<div class="tab-pane fade show active" id="kt_timeline_widget_3_tab_content_4" role="tabpanel">
							<div class="d-flex align-items-center mb-6">
								<span data-kt-element="bullet" class="bullet bullet-vertical d-flex align-items-center min-h-30px  me-4 bg-info"></span>
								<div class="flex-grow-1 me-5">
									<div class="text-gray-800 fw-semibold fs-4">{{$item_CategoryProduct -> name}}</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</a>
		@endforeach

	</div>










	<div class="col-md-10 col-xl-10">
		<div class="row">
			@foreach ($Product as $item_Product)
				<div class="col-md-6 col-xl-4">
					<div class="card border-hover-primary">
						<div class="card-header border-0 pt-9">
							<div class="card-title m-0" style="width: 100%;">
								<div style="width: 80%;margin: 0 auto">
									<img src="{{url("upload/Product")."/". $item_Product->image}}" alt="image" class="p-3" style="width:100%;border-radius: 15px !important;">
								</div>
							</div>
						</div>
						<div class="card-body p-9">

							<div style="display: flex;justify-content: space-between;">
								<div>
									<div class="fs-3 fw-bold text-dark">{{ $item_Product->name }}</div>
									<p class="text-gray-400 fw-semibold fs-5 mt-1 mb-7">{{ $item_Product->name_category }}</p>
								</div>

								<div class="card-toolbar">
									@if ($item_Product->active == 1)
										<span class="badge badge-light-success fw-bold me-auto px-4 py-3">فعال</span>
									@else
										<span class="badge badge-light-danger fw-bold me-auto px-4 py-3">غیر فعال</span>
									@endif
								</div>
							</div>



							<div class="d-flex flex-wrap mb-5"></div>




							

							<div style="display: flex;justify-content: space-between;">
								<div class="fs-3 text-dark" style="margin-top: 8px;">
									قیمت : {{number_format($item_Product->price)}} تومان
								</div>

								<div class="">
									@php
										$cartItem = carts::where('client_id', auth()->id())
											->where('product_id', $item_Product->id)
											->first();
									@endphp

									@if(!$cartItem)
										<button class="btn btn-success" onclick="addToCart({{ $item_Product->id }})">
											افزودن به سبد خرید
										</button>
									@else
										<div class="quantity-box">
											<button class="btn btn-danger" onclick="decrease({{ $item_Product->id }})">-</button>
											<span class="fw-bold fs-3 text-dark" style="padding: 15px;" id="qty-{{ $item_Product->id }}">{{ $cartItem->quantity }}</span>
											<button class="btn btn-success" onclick="increase({{ $item_Product->id }})">+</button>
										</div>
									@endif

								</div>
							</div>
								

		
						</div>
					</div>
				</div>
			@endforeach


		</div>


			<div class="card" style="margin-top: 10px;">
				{{ $Product->links('layouts.others.pagination') }}
			</div>

	</div>


</div>

	@section('script')
			<script>
				function addToCart(productId) {
					fetch("{{ url('client/addCart') }}", {
						method: "POST",
						headers: {
							"X-CSRF-TOKEN": "{{ csrf_token() }}",
							"Content-Type": "application/json"
						},
						body: JSON.stringify({ product_id: productId })
					}).then(() => location.reload());
				}

				function increase(productId) {
					fetch("{{ url('client/cartIncrease') }}", {
						method: "POST",
						headers: {
							"X-CSRF-TOKEN": "{{ csrf_token() }}",
							"Content-Type": "application/json"
						},
						body: JSON.stringify({ product_id: productId })
					}).then(() => location.reload());
				}

				function decrease(productId) {
					fetch("{{ url('client/cartDecrease') }}", {
						method: "POST",
						headers: {
							"X-CSRF-TOKEN": "{{ csrf_token() }}",
							"Content-Type": "application/json"
						},
						body: JSON.stringify({ product_id: productId })
					}).then(() => location.reload());
				}
			</script>
	@endsection

@endsection
