﻿@extends('layouts/client/header')
@section('title', 'ارسال تیکت')
@section('content')
<style>
.delete-item{
    position: absolute;
    left: -16px;
    top: 35px;
    cursor: pointer;
    color: red;
    width: 0;
}
</style>
    <div class="col-lg-12">
        <div class="card card-custom gutter-b  example-compact">
            <div class="card-header">
                <h5 class="card-title">
                    ارسال تیکت جدید
                </h5>
            </div>
            <!--begin::Form-->
            <form id="kt_inbox_compose_form" method="POST" action="{{ url('client/addTicket') }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="card-body pad-top-0">
                    <div class="row">
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">انتخاب دپارتمان</label>
							<!--begin::انتخاب-->
							<select name="department" data-control="select2" data-placeholder="انتخاب دپارتمان" class="form-select form-select-solid">
								<option value="">انتخاب دپارتمان</option>
								@foreach ($all_department as $item_department)
									<option value="{{$item_department -> id}}" >{{$item_department -> name}}</option>
								@endforeach
							</select>
							<!--end::انتخاب-->
						</div>
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">انتخاب اهمیت</label>
							<!--begin::انتخاب-->
							<select name="importance" data-control="select2" data-placeholder="انتخاب اهمیت" class="form-select form-select-solid">
								<option value="">انتخاب اهمیت</option>
								<option value="1" >کم</option>
								<option value="2" >متوسط</option>
								<option value="3" >زیاد</option>
							</select>
							<!--end::انتخاب-->
						</div>

                        <div class="col-lg-12 form-group mb-3" >
                            <label class="mb-3">موضوع</label>
                            <input id="title" type="text" class="form-control" name="title" value="{{ old('title') ?? '' }}"  placeholder="موضوع" required>
                        </div>

                        <div class="col-lg-12 form-group mb-3" style="height:400px">
                            <label class="mb-3">متن تیکت</label>
                            <textarea style="display:none" id="quill_html" name="description" style="height:400px"></textarea>
                            <div id="quill_editor" style="height:100%"></div>
                        </div>
                        
                        <div class="col-lg-12 form-group mb-3" style="margin-top:75px !important">
                            <label class="mb-3">آپلود فایل</label>
                            <input id="file" type="file" class="form-control" name="file" accept="jpg,.png,.jpeg,.pdf,.zip">
                        </div>
                        <div class="form-text">انواع فایل های مجاز: png ، jpg ، jpeg ، pdf ، zip</div>
                        <div class="fv-plugins-message-container invalid-feedback"></div>
                    </div>

                </div>
                <div class="card-footer">
                    <button class="btn btn-primary mr-2 nbbtn">ثبت</button>
                    <a href="{{url('subsetclient/index')}}" class="btn btn-danger">لغو</a>
                </div>
            </form>
            <!--end::Form-->
        </div>
    </div>



	@section('script')
        <script>
            var toolbarOptions = [
            ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
            ['blockquote', 'code-block'],

            [{ 'header': 1 }, { 'header': 2 }],               // custom button values
            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
            [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
            [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
            [{ 'direction': 'rtl' }],                         // text direction

            [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

            [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
            //[{ 'font': ['IRANSansWeb'] }],
            [{ 'align': [] }],

            ['clean']                                         // remove formatting button
            ];

            var quill = new Quill('#quill_editor', {
                    theme: 'snow',
                    debug: 'info',
                    modules: {
                        toolbar: toolbarOptions
                    },
            });
            
			quill.format('align', 'right');
            quill.on('text-change', function(delta, oldDelta, source) {
                    document.getElementById("quill_html").value = quill.root.innerHTML;
            });

        </script>
	@endsection


@endsection
