<!DOCTYPE html>
<html direction="rtl" dir="rtl" style="direction: rtl">

@php
    use App\Models\panel\settings;
    use App\Models\user;
    $settings = settings::all()->ToArray();
    if ($settings == []) {
        $logo_url = url('assets/panel/media/logos/logo-light.png');
        $logo_icon_url = url('assets/panel/media/logos/logo-light.png');
        $text_profile = 'برنامه نویس';
    } else {
        $settings = settings::find(1);
        if ($settings->logo != true) {
            $logo_url = url('assets/panel/media/logos/logo-light.png');
        } else {
            $logo_url = url('upload') . '/' . $settings->logo;
        }
        //--------------------------------------------------------------------------------------------
        if ($settings->logo_icon != true) {
            $logo_icon_url = url('assets/panel/media/logos/favicon.ico');
        } else {
            $logo_icon_url = url('upload') . '/' . $settings->logo_icon;
        }
        //--------------------------------------------------------------------------------------------
        if ($settings->text_profile != true) {
            $text_profile = 'برنامه نویس';
        } else {
            $text_profile = $settings->text_profile;
        }
    }
@endphp


	<!--begin::Head-->
	<head>
		<title>@yield('title')</title>
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="csrf-token" content="{{ csrf_token() }}" />
		<meta charset="utf-8" />
		<link rel="canonical" href="Https://preview.keenthemes.com/metronic8" />
		<link rel="shortcut icon" href="{{$logo_icon_url}}" />
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />

		<link href="{{ URL::asset('assets/panel/plugins/global/plugins.bundle.rtl.css')}}" rel="stylesheet" type="text/css" />
		<link href="{{ URL::asset('assets/panel/css/style.bundle.rtl.css')}}" rel="stylesheet" type="text/css" />

		<link href="{{ URL::asset('assets/panel/css/new_style.css')}}" rel="stylesheet" type="text/css" />
	</head>
	<body id="kt_body" class="app-blank app-blank bgi-size-cover bgi-position-center bgi-no-repeat">
		@include('layouts.others.errors')


		<div class="d-flex flex-column flex-root" id="kt_app_root">
			<style>body { background-image: url({{ URL::asset('assets/panel/media/auth/bg4.jpg')}}); } [data-theme="dark"] body { background-image: url({{ URL::asset('assets/panel/media/auth/bg4-dark.jpg')}});}</style>
			<div class="d-flex flex-column flex-column-fluid flex-lg-row">
				<div class="d-flex flex-center w-lg-50 pt-15 pt-lg-0 px-10">
					<div class="d-flex flex-center flex-lg-start flex-column">
						<a href="#" class="mb-7">
							<img alt="Logo" src="{{$logo_url}}" />
						</a>
						<h2 class="text-white fw-normal m-0">برای مدیریت وارد شوید</h2>
					</div>
	
				</div>

				<div class="d-flex flex-center w-lg-50 p-10">
					<div class="card rounded-3 w-md-550px">
						<div class="card-body p-10 p-lg-20">
                            @yield('content')
						</div>
					</div>
				</div>

			</div>

		</div>


		<script src="{{ URL::asset('assets/panel/plugins/global/plugins.bundle.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/scripts.bundle.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/authentication/sign-in/general.js')}}"></script>

		<script src="{{ URL::asset('assets/panel/plugins/custom/fullcalendar/fullcalendar.bundle.js')}}"></script>
		<script src="https://cdn.amcharts.com/lib/5/index.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/percent.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/radar.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/map.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/geodata/worldLow.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/geodata/continentsLow.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/geodata/usaLow.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/geodata/worldTimeZonesLow.js"></script>
		<script src="https://cdn.amcharts.com/lib/5/geodata/worldTimeZoneAreasLow.js"></script>
		<script src="{{ URL::asset('assets/panel/plugins/custom/datatables/datatables.bundle.js')}}"></script>

		<script src="{{ URL::asset('assets/panel/js/widgets.bundle.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/widgets.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/apps/chat/chat.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/utilities/modals/upgrade-plan.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/utilities/modals/create-app.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/utilities/modals/new-target.js')}}"></script>
		<script src="{{ URL::asset('assets/panel/js/custom/utilities/modals/users-search.js')}}"></script>

	<script>
		$( ".ok" ).on( "click", function() {
			$('.error').css('display','none');
		});
		$(".changepass").click(function(){
			$('#password').prop('type', 'text');
		});

		$( "div.bt-chaptcha" ).on( "click", function() {
			event.preventDefault();
			let _token   = $('meta[name="csrf-token"]').attr('content');
			$.ajax({
			url: "{{ url('captchaAjax') }}",
			type:"POST",
			data:{
				_token: _token
			},
			success:function(response){
				if(response) {
					$("#images_captacha").attr('src',response.imageSrc);
				}
			},
			});
		});
	</script>


	</body>
</html>