
@extends('layouts/panel/header')
@section('title', 'ویرایش آدرس')
@section('content')
	<div class="col-lg-12">
		<div class="card card-custom gutter-b  example-compact">
			<div class="card-header">
				<h3 class="card-title">
					ویرایش آدرس جدید
				</h3>
			</div>
			<!--begin::Form-->
			<form class="form-horizontal" method="POST" action="../editAddressHome/{{ $AddressHome->id }}" enctype="multipart/form-data">
				{{ csrf_field() }}
				<div class="card-body pad-top-0">
					<div class="row">
                        <div class="col-lg-6 form-group mb-3">
                        	<label class="mb-3">انتخاب کاربر</label>
                            <!--begin::انتخاب-->
                            <select name="client" data-control="select2" data-placeholder="انتخاب کاربر" class="form-select form-select-solid">
                                <option value="">انتخاب کاربر</option>
                                @foreach ($client as $item_client)
                                    <option value="{{$item_client -> id}}" @if ($item_client->id == $AddressHome->client_id) selected @endif>{{$item_client -> name}}</option>
                                @endforeach
                            </select>
                            <!--end::انتخاب-->
                        </div>

						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">نام آدرس</label>
							<input id="title" type="text" class="form-control" name="title" value="{{$AddressHome->title}}" placeholder="نام آدرس" required>
						</div>     
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">نام گیرنده</label>
							<input id="name_receiver" type="text" class="form-control" name="name_receiver" value="{{$AddressHome->name_receiver}}" placeholder="نام گیرنده" required>
						</div>  
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">شماره موبایل گیرنده</label>
							<input id="phone_receiver" type="text" class="form-control" name="phone_receiver" value="{{$AddressHome->phone_receiver}}" placeholder="شماره موبایل گیرنده" required>
						</div>  
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">کد پستی</label>
							<input id="postal_code" type="text" class="form-control" name="postal_code" value="{{$AddressHome->postal_code}}" placeholder="کد پستی" required>
						</div>  
						<div class="col-lg-12 form-group mb-3">
							<label class="mb-3">آدرس دقیق کد پستی ( همراه با پلاک و واحد )</label>
							<textarea id="address" class="form-control" name="address" placeholder="آدرس دقیق کد پستی ( همراه با پلاک و واحد )" required>{{$AddressHome->address}}</textarea>
						</div>  

					</div>
    
            
				</div>
				<div class="card-footer">
					<button class="btn btn-primary mr-2">ثبت</button>
					<a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
				</div>
			</form>
			<!--end::Form-->
		</div>
	</div>
@endsection
