﻿@extends('layouts/panel/header')
@section('title', 'افزودن کمپین')
@section('content')
<style>
.delete-item{
    position: absolute;
    left: -16px;
    top: 35px;
    cursor: pointer;
    color: red;
    width: 0;
}
</style>


	<div class="col-lg-12">
		<div class="card card-custom gutter-b  example-compact">
			<div class="card-header">
				<h3 class="card-title">
					افزودن کمپین جدید
				</h3>
			</div>
			<!--begin::Form-->
			<form class="form-horizontal" method="POST" action="{{ url('panel/addCampaign') }}" enctype="multipart/form-data">
				{{ csrf_field() }}
				<div class="card-body pad-top-0">
					<div class="row">
                        <div class="col-lg-6 form-group mb-3">
                        	<label class="mb-3">انتخاب دسته بندی</label>
                            <!--begin::انتخاب-->
                            <select name="categoryCampaign" data-control="select2" data-placeholder="انتخاب دسته بندی" class="form-select form-select-solid">
                                <option value="">انتخاب دسته بندی</option>
                                @foreach ($categoryCampaign as $item_categoryCampaign)
                                    <option value="{{$item_categoryCampaign -> id}}">{{$item_categoryCampaign -> name}}</option>
                                @endforeach
                            </select>
                            <!--end::انتخاب-->
                        </div>

                        <div class="col-lg-6 form-group mb-3">
                        	<label class="mb-3">انتخاب وضعیت</label>
                            <!--begin::انتخاب-->
                            <select name="status" data-control="select2" data-placeholder="انتخاب وضعیت" class="form-select form-select-solid">
                                <option value="">انتخاب وضعیت</option>
                                <option value="1">فعال</option>
                                <option value="2">تمام شده</option>
                                <option value="3">کنسل شده</option>
                                <option value="4">غیر فعال</option>
                            </select>
                            <!--end::انتخاب-->
                        </div>

						
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">نام</label>
							<input id="name" type="text" class="form-control" name="name" placeholder="نام" required>
						</div>    
						<div class="col-lg-6 form-group mb-3">
							<label class="mb-3">مبلغ کل هدف ( تومان )</label>
							<input id="price" type="number" class="form-control" name="price" placeholder="مبلغ کل هدف ( تومان )" required>
						</div>    

                        <div class="col-lg-12 form-group mb-3" style="height:400px">
                            <label class="mb-3">توضیحات کمپین</label>
                            <textarea style="display:none" id="quill_html" name="description" style="height:400px"></textarea>
                            <div id="quill_editor" style="height:100%"></div>
                        </div>


					</div>


					<div class="fv-row mb-10 fv-plugins-icon-container" style="margin-top:70px">
						<!--begin::Tags-->
						<label class="d-block fw-semibold fs-6 mb-5">
							<span>عکس</span>
						</label>
						<!--end::Tags-->
						<!--begin::Image input placeholder-->
						<style>.image-input-placeholder { background-image: url('{{url("assets/panel/media/svg/files/blank-image.svg")}}'); } [data-theme="dark"] .image-input-placeholder { background-image: url('{{url("assets/panel/media/svg/files/blank-image-dark.svg")}}'); }</style>
						<!--end::Image input placeholder-->
						<!--begin::Image input-->
						<div class="image-input image-input-empty image-input-outline image-input-placeholder" data-kt-image-input="true">
							<!--begin::نمایش existing image-->
							<div class="image-input-wrapper w-125px h-125px"></div>
							<!--end::نمایش existing image-->
							<!--begin::Tags-->
							<label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" aria-label="تعویض آواتار" data-bs-original-title="تعویض آواتار" data-kt-initialized="1">
								<i class="bi bi-pencil-fill fs-7"></i>
								<!--begin::Inputs-->
								<input type="file" name="image" accept=".png, .jpg, .jpeg" required>
								<input type="hidden" name="image_remove">
								<!--end::Inputs-->
							</label>
							<!--end::Tags-->
							<!--begin::انصراف-->
							<span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" aria-label="انصراف image" data-bs-original-title="انصراف image" data-kt-initialized="1">
								<i class="bi bi-x fs-2"></i>
							</span>
							<!--end::انصراف-->
							<!--begin::حذف-->
							<span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" aria-label="حذف آواتار" data-bs-original-title="حذف آواتار" data-kt-initialized="1">
								<i class="bi bi-x fs-2"></i>
							</span>
							<!--end::حذف-->
						</div>
						<!--end::Image input-->
						<!--begin::Hint-->
						<div class="form-text">انواع فایل های مجاز: png ، jpg ، jpeg.</div>
						<div class="fv-plugins-message-container invalid-feedback"></div>
					</div>    



            
				</div>
				<div class="card-footer">
					<button class="btn btn-primary mr-2">ثبت</button>
					<a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
				</div>
			</form>
			<!--end::Form-->
		</div>
	</div>



	@section('script')
        <script>
            var toolbarOptions = [
            ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
            ['blockquote', 'code-block'],

            [{ 'header': 1 }, { 'header': 2 }],               // custom button values
            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
            [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
            [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
            [{ 'direction': 'rtl' }],                         // text direction

            [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

            [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
            //[{ 'font': ['IRANSansWeb'] }],
            [{ 'align': [] }],

            ['clean']                                         // remove formatting button
            ];

            var quill = new Quill('#quill_editor', {
                    theme: 'snow',
                    debug: 'info',
                    modules: {
                        toolbar: toolbarOptions
                    },
            });
            
			quill.format('align', 'right');
            quill.on('text-change', function(delta, oldDelta, source) {
                    document.getElementById("quill_html").value = quill.root.innerHTML;
            });

        </script>
	@endsection

@endsection
