@extends('layouts/panel/header')
@section('title', 'همه کاربر بلاک شده ها')
@section('content')
@php
    use App\Models\panel\city;
    use App\Models\User;
@endphp
    <div class="col-lg-12">
        <div class="card card-custom gutter-b" style="margin-bottom: 30px;">
            <div class="card-header">
                <div class="card-title">
                    <h5 class="card-label" style="margin-right: 10px">جستجو پیشرفته</h5>
                </div>
            </div>
            <div class="card-body">
                <form class="form-horizontal" method="GET" action="{{ url('panel/searchBlockClient') }}">
                        <div class="row">

                            <div class="col-lg-6 form-group mb-3">
                                <label class="mb-3">انتخاب جستجو</label>
                                <!--begin::انتخاب-->
                                <select name="selectvalue" data-control="select2" data-placeholder="انتخاب جستجو" class="form-select form-select-solid">
                                    <option value="">انتخاب جستجو</option>
                                    <option value="name">نام و نام خانوادگی</option>
                                    <option value="email">ایمیل</option>
                                    <option value="phone">شماره موبایل</option>
                                </select>
                                <!--end::انتخاب-->
                            </div>
                            <div class="col-lg-6 form-group mb-3">
                                <label class="mb-3">متن جستجو</label>
                                <input id="name" type="text" class="form-control" name="search"  placeholder="متن جستجو">
                            </div>
                        </div>
                    <div class="card-footer" style="padding: 20px 0px 0px 0px;">
                        <button class="btn btn-primary mr-2">جستجو</button>
                    </div>
                </form>
            </div>
        </div>

        <div class="card card-custom table-responsive">
            <div class="card-header flex-wrap ">
                <div class="card-title">
                    <h5 class="card-label">
                        همه کاربر بلاک شده ها
                    </h5>
                </div>
            </div>
            <div class="card-body pad-top-0">
                <span class="linkdelete" style="display: none">{{url('panel/deleteClient')}}</span>
                <!--begin: جدول داده ها-->
                <table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
                    <thead>
                        <tr>
                            <th>نام و نام خانوادگی</th>
                            <th>ایمیل</th>
                            <th>شماره موبایل</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($all_user as $item_user)
                            <tr>
                                <td>{{ $item_user->name }}</td>
                                <td>{{ $item_user->email }}</td>
                                <td>{{ $item_user->phone }}</td>

                                <td>
                                    @if ($item_user->active == 1)
                                        <span class="badge badge-light-success nback">فعال</span>
                                    @else
                                        <span class="badge badge-light-danger nback">غیر فعال</span>
                                    @endif
                                </td>

                                <td class="delete-content">
                                    @if($item_user->active == 1)
                                        <a href="{{ url('panel/disableClient') . '/' . $item_user->id }}"
                                            class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="غیر فعال کردن">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                        <rect x="0" y="0" width="24" height="24"/>
                                                        <path fill="currentColor" d="M6,9 L6,15 C6,16.6568542 7.34314575,18 9,18 L15,18 L15,18.8181818 C15,20.2324881 14.2324881,21 12.8181818,21 L5.18181818,21 C3.76751186,21 3,20.2324881 3,18.8181818 L3,11.1818182 C3,9.76751186 3.76751186,9 5.18181818,9 L6,9 Z M17,16 L17,10 C17,8.34314575 15.6568542,7 14,7 L8,7 L8,6.18181818 C8,4.76751186 8.76751186,4 10.1818182,4 L17.8181818,4 C19.2324881,4 20,4.76751186 20,6.18181818 L20,13.8181818 C20,15.2324881 19.2324881,16 17.8181818,16 L17,16 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                                        <path fill="currentColor" d="M9.27272727,9 L13.7272727,9 C14.5522847,9 15,9.44771525 15,10.2727273 L15,14.7272727 C15,15.5522847 14.5522847,16 13.7272727,16 L9.27272727,16 C8.44771525,16 8,15.5522847 8,14.7272727 L8,10.2727273 C8,9.44771525 8.44771525,9 9.27272727,9 Z" fill="#000000"/>
                                                    </g>
                                                </svg>
                                            </span>
                                        </a>
                                    @else
                                        <a href="{{ url('panel/activeClient') . '/' . $item_user->id }}"
                                            class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="فعال کردن">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                        <rect x="0" y="0" width="24" height="24"/>
                                                        <path fill="currentColor" d="M6,9 L6,15 C6,16.6568542 7.34314575,18 9,18 L15,18 L15,18.8181818 C15,20.2324881 14.2324881,21 12.8181818,21 L5.18181818,21 C3.76751186,21 3,20.2324881 3,18.8181818 L3,11.1818182 C3,9.76751186 3.76751186,9 5.18181818,9 L6,9 Z M17,16 L17,10 C17,8.34314575 15.6568542,7 14,7 L8,7 L8,6.18181818 C8,4.76751186 8.76751186,4 10.1818182,4 L17.8181818,4 C19.2324881,4 20,4.76751186 20,6.18181818 L20,13.8181818 C20,15.2324881 19.2324881,16 17.8181818,16 L17,16 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                                        <path fill="currentColor" d="M9.27272727,9 L13.7272727,9 C14.5522847,9 15,9.44771525 15,10.2727273 L15,14.7272727 C15,15.5522847 14.5522847,16 13.7272727,16 L9.27272727,16 C8.44771525,16 8,15.5522847 8,14.7272727 L8,10.2727273 C8,9.44771525 8.44771525,9 9.27272727,9 Z" fill="#000000"/>
                                                    </g>
                                                </svg>
                                            </span>
                                        </a>
                                    @endif
                                    <a href="{{ url('panel/profileClient') . '/' . $item_user->id }}"
                                        class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="پروفایل">
                                        <span> <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="0" y="0" width="24" height="24"></rect>
                                                <path fill="currentColor" d="M3.5,21 L20.5,21 C21.3284271,21 22,20.3284271 22,19.5 L22,8.5 C22,7.67157288 21.3284271,7 20.5,7 L10,7 L7.43933983,4.43933983 C7.15803526,4.15803526 6.77650439,4 6.37867966,4 L3.5,4 C2.67157288,4 2,4.67157288 2,5.5 L2,19.5 C2,20.3284271 2.67157288,21 3.5,21 Z" fill="#000000" opacity="0.3"></path>
                                                <path fill="currentColor" d="M12,13 C10.8954305,13 10,12.1045695 10,11 C10,9.8954305 10.8954305,9 12,9 C13.1045695,9 14,9.8954305 14,11 C14,12.1045695 13.1045695,13 12,13 Z" fill="#000000" opacity="0.3"></path>
                                                <path fill="currentColor" d="M7.00036205,18.4995035 C7.21569918,15.5165724 9.36772908,14 11.9907452,14 C14.6506758,14 16.8360465,15.4332455 16.9988413,18.5 C17.0053266,18.6221713 16.9988413,19 16.5815,19 C14.5228466,19 11.463736,19 7.4041679,19 C7.26484009,19 6.98863236,18.6619875 7.00036205,18.4995035 Z" fill="#000000" opacity="0.3"></path>
                                            </g>
                                        </svg> </span>
                                    </a>
                                    <a href="{{ url('panel/editClient') . '/' . $item_user->id }}"
                                        class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="ویرایش">
                                        <span> <svg xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                                viewBox="0 0 24 24" version="1.1">
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <rect x="0" y="0" width="24" height="24"></rect>
                                                    <path fill="currentColor"
                                                        d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z"
                                                        fill="#000000" fill-rule="nonzero"
                                                        transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) ">
                                                    </path>
                                                    <rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2"
                                                        rx="1"></rect>
                                                </g>
                                            </svg> </span>
                                    </a>
                                    <a class="btn btn-sm btn-clean btn-icon btns-delete" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="حذف">
                                        <span> 
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                                viewBox="0 0 24 24" version="1.1">
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <rect x="0" y="0" width="24" height="24"></rect>
                                                    <path fill="currentColor"
                                                        d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
                                                        fill="#000000" fill-rule="nonzero"></path>
                                                    <path fill="currentColor"
                                                        d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
                                                        fill="#000000" opacity="0.3"></path>
                                                </g>
                                            </svg> 
                                        </span>
                                    </a>
                                    <input type="text" class="value-delete" style="display:none" value="{{$item_user -> id}}" />
                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                </table>
                <!--end: جدول داده ها-->
            </div>
            <div>
                {{ $all_user->links('layouts.others.pagination') }}
            </div>
        </div>
    </div>
 


    
    <div class="swal2-container swal2-rtl swal2-center swal2-backdrop-show box-delete" style="display:none" style="overflow-y: auto;">
      <div aria-labelledby="swal2-title" aria-describedby="swal2-html-container" class="swal2-popup swal2-modal swal2-icon-error swal2-show" tabindex="-1" role="dialog" aria-live="assertive" aria-modal="true" style="display: grid;">
            <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;"><div class="swal2-icon-content">!</div></div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">آیا مطمئن هستید؟</div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">درصورت حذف امکان بازگردانی جود ندارد!</div>
      <div class="swal2-actions" style="display: flex;margin-bottom: 30px;">
      <div class="swal2-loader"></div>

        <button class="swal2-confirm btn btn-danger btns-delete-cancele" aria-label="" style="display: inline-block;margin:0" >نه کنسل کن</button>
        <div class="swal-button-container">
            <form action="" method="POST" class="form-delete" style="margin:0">
                {{method_field('delete')}}
                {{ csrf_field()}}
                <button class="swal2-confirm btn btn-success" style="margin-top: 0">بله حذف کن</button>
            </form>
        </div>

      </div>
      </div>
      </div>





@endsection
