﻿@extends('layouts/panel/header')
@section('title', 'همه فاکتور پرداخت نشده ها')
@section('content')
@php
	use App\Models\portal\portals;
@endphp


<div class="col-lg-12">


        <div class="card card-custom gutter-b" style="margin-bottom: 30px;">
            <div class="card-header">
                <div class="card-title">
                    <h5 class="card-label" style="margin-right: 10px">جستجو پیشرفته</h5>
                </div>
            </div>
            <div class="card-body">
                <form class="form-horizontal" method="GET" action="{{ url('panel/searchFactorNotPay') }}">
                        <div class="row">
                            <div class="col-lg-4 form-group mb-3">
                                <label class="mb-3">انتخاب جستجو</label>
                                <!--begin::انتخاب-->
                                <select name="selectvalue" data-control="select2" data-placeholder="انتخاب جستجو" class="form-select form-select-solid">
                                    <option value="">انتخاب جستجو</option>
                                    <option value="name">نام و نام خانوادگی</option>
                                    <option value="phone">شماره موبایل</option>
                                </select>
                                <!--end::انتخاب-->
                            </div>

                            <div class="col-lg-4 form-group mb-3">
                                <label class="mb-3">انتخاب نوع فاکتور</label>
                                <!--begin::انتخاب-->
                                <select name="typeFactor" data-control="select2" data-placeholder="انتخاب نوع فاکتور" class="form-select form-select-solid">
                                    <option value="">انتخاب نوع فاکتور</option>
                                    <option value="campaign">کمپین</option>
                                    <option value="product">خرید محصول</option>
                                    <option value="subsidy">حمایت مالی</option>
                                </select>
                                <!--end::انتخاب-->
                            </div>


                            <div class="col-lg-4 form-group mb-3">
                                <label class="mb-3">متن جستجو</label>
                                <input id="name" type="text" class="form-control" name="search"  placeholder="متن جستجو">
                            </div>
                        </div>
                    <div class="card-footer" style="padding: 20px 0px 0px 0px;">
                        <button class="btn btn-primary mr-2">جستجو</button>
                    </div>
                </form>
            </div>
        </div>





	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h5 class="card-label">
					همه فاکتور پرداخت نشده ها
				</h5>
			</div>
		</div>
		<div class="card-body pad-top-0">
				<span class="linkdelete" style="display: none">{{url('panel/deleteFactor')}}</span>
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>شماره فاکتور</th>
						<th>نام و نام خانوادگی</th>
						<th>نام فاکتور</th>
						<th>شماره موبایل</th>
						<th>مبلغ پرداخت</th>
						<th>درگاه</th>
						<th>وضعیت</th>
						<th>تاریخ صدور فاکتور</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($factor as $item_charge_wallet)
						<tr>
							<td>{{$item_charge_wallet->id}} #</td>
							<td>{{$item_charge_wallet->array_user->name}}</td>
							<td>
								{{$item_charge_wallet -> text_factor}}
							</td>
							<td>{{$item_charge_wallet->array_user->phone}}</td>
							<td>{{ number_format($item_charge_wallet->price) }} تومان</td>
							<td>
								<span class="badge badge-light-warning nback">{{ $item_charge_wallet -> name_banks }}</span>
							</td> 
							<td>
								@if($item_charge_wallet->payment == 0)
									<span class="badge badge-light-warning nback">پرداخت نشده</span>
								@elseif($item_charge_wallet->payment == 1)
									<span class="badge badge-light-success nback">پرداخت شده</span>
								@elseif($item_charge_wallet->payment == 3)
									<span class="badge badge-light-danger nback">پس داده شده</span>
								@else
									<span class="badge badge-light-danger nback">لغو شده</span>
								@endif
							</td>
							
							<td>
								{{$item_charge_wallet -> created_at}}
							</td>
							<td class="delete-content">
								<a href="{{ url('panel/factor') . '/' . $item_charge_wallet->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="نمایش">
									<span>
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"/>
												<path d="M13,5 L15,5 L15,20 L13,20 L13,5 Z M5,5 L5,20 L3,20 C2.44771525,20 2,19.5522847 2,19 L2,6 C2,5.44771525 2.44771525,5 3,5 L5,5 Z M16,5 L18,5 L18,20 L16,20 L16,5 Z M20,5 L21,5 C21.5522847,5 22,5.44771525 22,6 L22,19 C22,19.5522847 21.5522847,20 21,20 L20,20 L20,5 Z" fill="#000000"/>
												<polygon fill="#000000" opacity="0.3" points="9 5 9 20 7 20 7 5"/>
											</g>
										</svg>
									</span>
								</a>

								<a class="btn btn-sm btn-clean btn-icon btns-delete" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="حذف">
									<span> 
										<svg xmlns="http://www.w3.org/2000/svg"
											xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
											viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"></rect>
												<path
													d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
													fill="#000000" fill-rule="nonzero"></path>
												<path
													d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
													fill="#000000" opacity="0.3"></path>
											</g>
										</svg> 
									</span>
								</a>
								<input type="text" class="value-delete" style="display:none" value="{{$item_charge_wallet -> id}}" />

							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
		<div>
			{{ $factor->links('layouts.others.pagination') }}
		</div>
	</div>
</div>



    <div class="swal2-container swal2-rtl swal2-center swal2-backdrop-show box-delete" style="display:none" style="overflow-y: auto;">
      <div aria-labelledby="swal2-title" aria-describedby="swal2-html-container" class="swal2-popup swal2-modal swal2-icon-error swal2-show" tabindex="-1" role="dialog" aria-live="assertive" aria-modal="true" style="display: grid;">
            <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;"><div class="swal2-icon-content">!</div></div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">آیا مطمئن هستید؟</div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">درصورت حذف امکان بازگردانی جود ندارد!</div>
      <div class="swal2-actions" style="display: flex;margin-bottom: 30px;">
      <div class="swal2-loader"></div>

        <button class="swal2-confirm btn btn-danger btns-delete-cancele" aria-label="" style="display: inline-block;margin:0" >نه کنسل کن</button>
        <div class="swal-button-container">
            <form action="" method="POST" class="form-delete" style="margin:0">
                {{method_field('delete')}}
                {{ csrf_field()}}
                <button class="swal2-confirm btn btn-success" style="margin-top: 0">بله حذف کن</button>
            </form>
        </div>

      </div>
      </div>
      </div>



@endsection
