@extends('layouts/panel/header')
@section('title', 'ویرایش محصول')
@section('content')
<style>
.delete-item{
    position: absolute;
    left: -16px;
    top: 35px;
    cursor: pointer;
    color: red;
    width: 0;
}
</style>



	<div class="col-lg-12">
		<div class="card card-custom gutter-b  example-compact">
			<div class="card-header">
				<h3 class="card-title">
					ویرایش محصول 
				</h3>
			</div>
			<!--begin::Form-->
			<form class="form-horizontal" method="POST" action="../editProduct/{{ $Product->id }}" enctype="multipart/form-data">
				{{ csrf_field() }}
				<div class="card-body pad-top-0">
					<div class="row">
                        <div class="col-lg-4 form-group mb-3">
                        	<label class="mb-3">انتخاب دسته بندی</label>
                            <!--begin::انتخاب-->
                            <select name="categoryProduct" data-control="select2" data-placeholder="انتخاب دسته بندی" class="form-select form-select-solid">
                                <option value="">انتخاب دسته بندی</option>
                                @foreach ($categoryProduct as $item_CategoryProduct)
                                    <option value="{{$item_CategoryProduct -> id}}" @if($item_CategoryProduct -> id == $Product->id_category) selected  @endif>{{$item_CategoryProduct -> name}}</option>
                                @endforeach
                            </select>
                            <!--end::انتخاب-->
                        </div>

						<div class="col-lg-4 form-group mb-3">
							<label class="mb-3">نام</label>
							<input id="name" type="text" class="form-control" name="name" value="{{ $Product->name }}" placeholder="نام" required>
						</div>     
                        
                        <div class="col-lg-4 form-group mb-3">
							<label class="mb-3">مبلغ ( تومان )</label>
							<input id="price" type="number" class="form-control" name="price" value="{{ $Product->price }}" placeholder="مبلغ ( تومان )" required>
						</div>    


					</div>


                    <div class="fv-row mb-10 fv-plugins-icon-container">
                        <!--begin::Tags-->
                        <label class="d-block fw-semibold fs-6 mb-5">
                            <span>عکس آواتار</span>
                        </label>

                        <style>.image-input-placeholder { background-image: url('{{url("upload/Product")."/". $Product->image}}'); } [data-theme="dark"] .image-input-placeholder { background-image: url('{{url("upload/Product")."/". $Product->image}}')); }</style>

                        <div class="image-input image-input-empty image-input-outline image-input-placeholder" data-kt-image-input="true">
                            <!--begin::نمایش existing image-->
                            <div class="image-input-wrapper w-125px h-125px"></div>
                            <!--end::نمایش existing image-->
                            <!--begin::Tags-->
                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" aria-label="تعویض آواتار" data-bs-original-title="تعویض آواتار" data-kt-initialized="1">
                                <i class="bi bi-pencil-fill fs-7"></i>
                                <!--begin::Inputs-->
                                <input type="file" name="image" accept=".png, .jpg, .jpeg">
                                <input type="hidden" name="image_remove">
                                <!--end::Inputs-->
                            </label>
                            <!--end::Tags-->
                            <!--begin::انصراف-->
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" aria-label="انصراف image" data-bs-original-title="انصراف image" data-kt-initialized="1">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <!--end::انصراف-->
                            <!--begin::حذف-->
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" aria-label="حذف آواتار" data-bs-original-title="حذف آواتار" data-kt-initialized="1">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <!--end::حذف-->
                        </div>
                        <!--end::Image input-->
                        <!--begin::Hint-->
                        <div class="form-text">انواع فایل های مجاز: png ، jpg ، jpeg.</div>
						<div class="fv-plugins-message-container invalid-feedback"></div>
                    </div>

                    <div class="row" style="margin-top:20px">
                        <div class="col-lg-1 form-group mb-3">
                            <div class="form-check form-check-inline checkbox checkbox-primary">
                                <input class="form-check-input checkboxes" id="inline-form-4" type="checkbox" name="active" data-bs-original-title="" title="" @if ($Product -> active == 1) checked @endif >
                                <label class="form-check-label" for="inline-form-4">فعال</label>
                            </div>
                        </div>                
					</div>        




            
				</div>
				<div class="card-footer">
					<button class="btn btn-primary mr-2">ثبت</button>
					<a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
				</div>
			</form>
			<!--end::Form-->
		</div>
	</div>




@endsection
