@extends('layouts/panel/header')
@section('title', 'تیکت')
@section('content')
@php 
use App\Models\User;
use App\Models\panel\pm_ticket;
use App\Models\panel\department;
@endphp

    <div class="col-lg-12">
        <div class="card card-custom gutter-b example-compact">
            <div class="card-header">
                <h5 class="card-title">
                    تیکت
                </h5>
            </div>
			<div class="card-body pad-top-0">
				<div>
					<div class="form-group row my-2">
						<label class="col-4 col-form-label">شماره تیکت:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								{{$ticket -> id}} #
							</span>
						</div>
					</div>
					<div class="form-group row my-2">
						<label class="col-4 col-form-label">موضوع:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								{{$ticket -> title}}
							</span>
						</div>
					</div>



					<div class="form-group row my-2">
						<label class="col-4 col-form-label">دپارتمان:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								@php 
									$find_department = department::find($ticket -> department);
									if($find_department != null){
										echo $find_department -> name;
									}else{
										echo '-';
									}
								@endphp
							</span>
						</div>
					</div>


					<div class="form-group row my-2">
						<label class="col-4 col-form-label">اهمیت:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								@if ($ticket -> importance == 1)
									کم
								@elseif ($ticket -> importance == 2)
									متوسط
								@else
									زیاد
								@endif
							</span>
						</div>
					</div>

					<div class="form-group row my-2">
						<label class="col-4 col-form-label">وضعیت:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								@if ($ticket -> status == 1)
									<span class="badge badge-light-success nback">باز</span>
								@elseif ($ticket -> status == 3)
									<span class="badge badge-light-success nback">در انتظار پاسخ</span>
								@elseif ($ticket -> status == 4)
									<span class="badge badge-light-info nback">پاسخ داده شده</span>
								@elseif ($ticket -> status == 5)
									<span class="badge badge-light-warning nback">در حال رسیدگی</span>
								@elseif ($ticket -> status == 6)
									<span class="badge badge-light-success nback">از طرف ادمین</span>
								@else
									<span class="badge badge-light-danger nback">بسته</span>
								@endif
							</span>
						</div>
					</div>


					<div class="form-group row my-2">
						<label class="col-4 col-form-label">تاریخ ایجاد تیکت:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								@php
									$varta = new \Verta($ticket -> created_at);
									echo $varta;    
								@endphp
							</span>
						</div>
					</div>




					<div class="form-group row my-2">
						<label class="col-4 col-form-label">زمان سپری شده:</label>
						<div class="col-8">
							<span class="form-control-plaintext font-weight-bolder newfont">
								@php
									$varta = new \Verta($ticket -> updated_at);
									$time = $varta ->formatDifference();
									echo $time;    
								@endphp
							</span>
						</div>
					</div>






				</div>
			</div>





            <form id="kt_inbox_compose_form" method="POST" action="../updateTicket/{{ $ticket->id }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="card-body pad-top-0">
                    <div class="row">

                        <div class="col-lg-12 form-group mb-3">
                            <label class="mb-3">انتخاب وضعیت</label>
                            <!--begin::انتخاب-->
                            <select name="status" data-control="select2" data-placeholder="انتخاب وضعیت" class="form-select form-select-solid" required>
                                <option value="">انتخاب وضعیت</option>
                                <option value="1" @if($ticket->status == 1) selected @endif>باز</option>
                                <option value="2" @if($ticket->status == 2) selected @endif >بسته</option>
                                <option value="3" @if($ticket->status == 3) selected @endif >در انتظار پاسخ</option>
                                <option value="4" @if($ticket->status == 4) selected @endif >پاسخ داده شده</option>
                                <option value="5" @if($ticket->status == 5) selected @endif >در حال رسیدگی</option>
                                <option value="6" @if($ticket->status == 6) selected @endif >از طرف ادمین</option>
                            </select>
                            <!--end::انتخاب-->
                        </div>

                        <div class="col-lg-12 form-group mb-3" style="height:400px">
                            <label class="mb-3">متن تیکت</label>
                            <textarea style="display:none" id="quill_html" name="description" style="height:400px"></textarea>
                            <div id="quill_editor" style="height:100%"></div>
                        </div>
                        
                        <div class="col-lg-12 form-group mb-3" style="margin-top:75px !important">
                            <label class="mb-3">آپلود فایل</label>
                            <input id="file" type="file" class="form-control" name="file" accept="jpg,.png,.jpeg,.pdf,.zip">
                        </div>
                        <div class="form-text">انواع فایل های مجاز: png ، jpg ، jpeg ، pdf ، zip</div>
                        <div class="fv-plugins-message-container invalid-feedback"></div>
                    </div>

                </div>
                <div class="card-footer">
                    <button class="btn btn-primary mr-2 nbbtn">ثبت</button>
					@if ($ticket -> status != 2)
						<input type="submit" class="btn btn-danger mr-2 nbbtn" value="بستن" name="close" />
					@endif
                </div>
            </form>





        </div>
    </div>












    <div class="col-lg-12" style="margin-top:20px">
        <div class="card card-custom gutter-b example-compact">
            <div class="card-header">
                <h5 class="card-title">
                    ارسال شده ها
                </h5>
            </div>
			<div class="card-body pad-top-0">
				<div>

					@foreach ($all_pm_ticket as $item)

						<div data-kt-inbox-message="message_wrapper">
							<!--begin::پیام header-->
							<div class="d-flex flex-wrap gap-2 flex-stack cursor-pointer" data-kt-inbox-message="header">
								<!--begin::نویسنده-->
								<div class="d-flex align-items-center">
									<!--begin::Avatar-->
									<div class="symbol symbol-50 me-4">
										@php
											if($item -> type == "client"){
												$user = User::find($item -> client_id);
											}else{
												$user = User::find($item -> admin_id);
											}
											if($user != null){
												$image = url('upload'.'/'.$user -> avatar);
											}else{
												$image = url('assets/panel/media/avatars/300-6.jpg');
											}
										@endphp


										<span class="symbol-label" style="background-image:url({{$image}});"></span>
									</div>
									<!--end::Avatar-->
									<div class="pe-5">
										<!--begin::نویسنده details-->
										<div class="d-flex align-items-center flex-wrap gap-1">
											<a class="fw-bold text-dark text-hover-primary">
												@php
													if($item -> type == "client"){
														$user = User::find($item -> client_id);
													}else{
														$user = User::find($item -> admin_id);
													}
													if($user != null){
														echo $user -> name;
													}else{
														echo '-';
													}
												@endphp
											</a>
											<!--begin::Svg Icon | path: icons/duotune/abstract/abs050.svg-->
											<span class="svg-icon svg-icon-7 svg-icon-success mx-3">
												<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
													<circle fill="currentColor" cx="12" cy="12" r="8"></circle>
												</svg>
											</span>
											<!--end::Svg Icon-->

										</div>
										<!--end::نویسنده details-->
										<!--begin::پیام details-->
										<div data-kt-inbox-message="details">
											<span class="text-muted fw-bold">
											
												@php
													$varta = new \Verta($item -> created_at);
													$time = $varta ->formatDifference();
													echo $time;    
												@endphp
											
											</span>
										</div>

									</div>
								</div>
								<!--end::نویسنده-->
								<!--begin::Actions-->
								<div class="d-flex align-items-center flex-wrap gap-2">
									<!--begin::تاریخ-->
									<span class="fw-semibold text-muted text-end me-3">
											@php
												$varta2 = new \Verta($item -> created_at);
												echo $varta2;    
											@endphp
									</span>
									<!--end::تاریخ-->
									
								</div>
								<!--end::Actions-->
							</div>
							<!--end::پیام header-->
							<!--begin::پیام content-->
							<div class="collapse fade show" data-kt-inbox-message="message">
								<div class="py-5 pms">
								 	{!! html_entity_decode($item -> description) !!}
								</div>
							</div>


							@if (!empty($item -> file))
								<a target="_blank" href="{{url('upload/ticket'.'/'.$item -> file)}}" class="fw-bold text-dark text-hover-primary">دانلود فایل آپلود شده</a>
							@endif

							<!--end::پیام content-->
						</div>

						<div class="separator my-6"></div>

					@endforeach


				</div>
			</div>

            <div>
                {{ $all_pm_ticket->links('layouts.others.pagination') }}
            </div>


        </div>
    </div>




































	@section('script')

        <script>
		

            var toolbarOptions = [
            ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
            ['blockquote', 'code-block'],

            [{ 'header': 1 }, { 'header': 2 }],               // custom button values
            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
            [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
            [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
            [{ 'direction': 'rtl' }],                         // text direction

            [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

            [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
            //[{ 'font': ['IRANSansWeb'] }],
            [{ 'align': [] }],

            ['clean']                                         // remove formatting button
            ];

            var quill = new Quill('#quill_editor', {
                    theme: 'snow',
                    debug: 'info',
                    modules: {
                        toolbar: toolbarOptions
                    },
            });

			quill.format('align', 'right');
            quill.on('text-change', function(delta, oldDelta, source) {
                    document.getElementById("quill_html").value = quill.root.innerHTML;
            });
			
        </script>
	@endsection







@endsection
