@extends('layouts/panel/header')
@section('title', 'تنظیمات پنل')
@section('content')
    <div class="col-lg-12">
        <div class="card card-custom gutter-b  example-compact">
            <div class="card-header">
                <h3 class="card-title">
                    تنظیمات پنل
                </h3>
            </div>
            <!--begin::Form-->
            <form class="form-horizontal" method="POST" action="{{ url('panel/settings') }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="card-body pad-top-0">
                    <div class="row">
                        <div class="col-lg-6 form-group mb-3">
                            <label class="mb-3">نام سایت</label>
                            <input type="text" class="form-control" name="site_name" value="@if($settings == true){{$settings -> site_name}}@endif" placeholder="نام سایت">
                        </div>
                        <div class="col-lg-6 form-group mb-3">
                            <label class="mb-3">توضیحات از جانب خود برای مثال ( برنامه نویس)</label>
                            <input type="text" class="form-control" name="text_profile" value="@if($settings == true){{$settings -> text_profile}}@endif" placeholder="توضیحات از جانب خود برای مثال ( برنامه نویس)">
                        </div>
              
                    </div>

                    <div class="row" style="margin-top:20px">


                        <div class="col-lg-3">
                            <div class="fv-row mb-10 fv-plugins-icon-container">
                                <!--begin::Tags-->
                                <label class="d-block fw-semibold fs-6 mb-5">
                                    <span>لوگو سایت</span>
                                </label>
                                <!--end::Tags-->
                                <!--begin::Image input placeholder-->
                                <style>.image-input-placeholder1 { background-image: url('@if($settings == true) @if($settings -> logo == true) {{url("upload") . "/" . $settings -> logo}} @else {{url("assets/panel/media/svg/files/blank-image.svg")}} @endif @else {{url("assets/panel/media/svg/files/blank-image.svg")}} @endif'); } [data-theme="dark"] .image-input-placeholder { background-image: url('@if($settings == true) @if($settings -> logo == true) {{url("upload") . "/" . $settings -> logo}} @else {{url("assets/panel/media/users/assets/panel/media/svg/files/blank-image-dark.svg")}} @endif @else {{url("assets/panel/media/svg/files/blank-image-dark.svg")}} @endif'); }</style>
                                <!--end::Image input placeholder-->
                                <!--begin::Image input-->
                                <div class="image-input image-input-empty image-input-outline image-input-placeholder1" data-kt-image-input="true">
                                    <!--begin::نمایش existing avatar-->
                                    <div class="image-input-wrapper w-125px h-125px"></div>
                                    <!--end::نمایش existing avatar-->
                                    <!--begin::Tags-->
                                    <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" aria-label="تعویض آواتار" data-bs-original-title="تعویض آواتار" data-kt-initialized="1">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                        <!--begin::Inputs-->
                                        <input type="file" name="logo" accept=".png, .jpg, .jpeg">
                                        <input type="hidden" name="logo_remove">
                                        <!--end::Inputs-->
                                    </label>
                                    <!--end::Tags-->
                                    <!--begin::انصراف-->
                                    <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" aria-label="انصراف avatar" data-bs-original-title="انصراف avatar" data-kt-initialized="1">
                                        <i class="bi bi-x fs-2"></i>
                                    </span>
                                    <!--end::انصراف-->
                                    <!--begin::حذف-->
                                    <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" aria-label="حذف آواتار" data-bs-original-title="حذف آواتار" data-kt-initialized="1">
                                        <i class="bi bi-x fs-2"></i>
                                    </span>
                                    <!--end::حذف-->
                                </div>
                                <!--end::Image input-->
                                <!--begin::Hint-->
                                <div class="form-text">انواع فایل های مجاز: png ، jpg ، jpeg.</div>
                                <div class="fv-plugins-message-container invalid-feedback"></div>
                            </div>
                        </div>





                        <div class="col-lg-3">
                            <div class="fv-row mb-10 fv-plugins-icon-container">
                                <!--begin::Tags-->
                                <label class="d-block fw-semibold fs-6 mb-5">
                                    <span>لوگو آیکن</span>
                                </label>
                                <!--end::Tags-->
                                <!--begin::Image input placeholder-->
                                <style>.image-input-placeholder3 { background-image: url('@if($settings == true) @if($settings -> logo_icon == true) {{url("upload") . "/" . $settings -> logo_icon}} @else {{url("assets/panel/media/svg/files/blank-image.svg")}} @endif @else {{url("assets/panel/media/svg/files/blank-image.svg")}} @endif'); } [data-theme="dark"] .image-input-placeholder { background-image: url('@if($settings == true) @if($settings -> logo_icon == true) {{url("upload") . "/" . $settings -> logo_icon}} @else {{url("assets/panel/media/users/assets/panel/media/svg/files/blank-image-dark.svg")}} @endif @else {{url("assets/panel/media/svg/files/blank-image-dark.svg")}} @endif'); }</style>
                                <!--end::Image input placeholder-->
                                <!--begin::Image input-->
                                <div class="image-input image-input-empty image-input-outline image-input-placeholder3" data-kt-image-input="true">
                                    <!--begin::نمایش existing avatar-->
                                    <div class="image-input-wrapper w-125px h-125px"></div>
                                    <!--end::نمایش existing avatar-->
                                    <!--begin::Tags-->
                                    <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" aria-label="تعویض آواتار" data-bs-original-title="تعویض آواتار" data-kt-initialized="1">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                        <!--begin::Inputs-->
                                        <input type="file" name="logo_icon" accept=".png, .jpg, .jpeg">
                                        <input type="hidden" name="logo_icon_remove">
                                        <!--end::Inputs-->
                                    </label>
                                    <!--end::Tags-->
                                    <!--begin::انصراف-->
                                    <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" aria-label="انصراف avatar" data-bs-original-title="انصراف avatar" data-kt-initialized="1">
                                        <i class="bi bi-x fs-2"></i>
                                    </span>
                                    <!--end::انصراف-->
                                    <!--begin::حذف-->
                                    <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" aria-label="حذف آواتار" data-bs-original-title="حذف آواتار" data-kt-initialized="1">
                                        <i class="bi bi-x fs-2"></i>
                                    </span>
                                    <!--end::حذف-->
                                </div>
                                <!--end::Image input-->
                                <!--begin::Hint-->
                                <div class="form-text">انواع فایل های مجاز: png ، jpg ، jpeg.</div>
                                <div class="fv-plugins-message-container invalid-feedback"></div>
                            </div>
                        </div>




                        @if($settings == true) 
                            @if($settings->activation == true)
                                @php
                                    $attributes = json_decode($settings->activation,true);
                                    $send_sms_ticket_admin = $attributes[0]['send_sms_ticket_admin'];
                                    $send_sms_ticket_client = $attributes[0]['send_sms_ticket_client'];
                                    $send_sms_register = $attributes[0]['send_sms_register'];
                                    $send_sms_login = $attributes[0]['send_sms_login'];



                                    $sms_order = $attributes[0]['sms_order'];
                                    $sms_goods = $attributes[0]['sms_goods'];



                                @endphp
                            @else
                                @php
                                    $send_sms_ticket_admin = 0;
                                    $send_sms_ticket_client = 0;
                                    $send_sms_register = 0;
                                    $send_sms_login = 0;


                                    $sms_order = 0;
                                    $sms_goods = 0;


                                @endphp
                            @endif
                        @else
                            @php
                                $send_sms_ticket_admin = 0;
                                $send_sms_ticket_client = 0;
                                $send_sms_register = 0;
                                $send_sms_login = 0;

                                $sms_order = 0;
                                $sms_goods = 0;

                            @endphp

                        @endif







                        
                        <div class="col-lg-12">

                            <div class="form-check form-check-inline checkbox checkbox-primary mb-3">
                                <input class="form-check-input checkboxes checkbox_product check_active" type="checkbox" @if ($send_sms_ticket_admin == 1) checked @endif name="send_sms_ticket_admin">
                                <label class="form-check-label">ارسال پیامک به ادمین هنگام تغییر وضعیت تیکت</label>
                            </div>

                            <div class="form-check form-check-inline checkbox checkbox-primary mb-3">
                                <input class="form-check-input checkboxes checkbox_product check_active" type="checkbox" @if ($send_sms_ticket_client == 1) checked @endif name="send_sms_ticket_client">
                                <label class="form-check-label">ارسال پیامک به کاربر هنگام تغییر وضعیت تیکت</label>
                            </div>

                            <div class="form-check form-check-inline checkbox checkbox-primary mb-3">
                                <input class="form-check-input checkboxes checkbox_product check_active" type="checkbox" @if ($send_sms_register == 1) checked @endif name="send_sms_register">
                                <label class="form-check-label">ارسال پیامک خوش آمد گویی هنگام ثبت نام کاربر</label>
                            </div>

                            <div class="form-check form-check-inline checkbox checkbox-primary mb-3">
                                <input class="form-check-input checkboxes checkbox_product check_active" type="checkbox" @if ($send_sms_login == 1) checked @endif name="send_sms_login">
                                <label class="form-check-label">ارسال پیامک خوش آمد گویی هنگام لاگین کاربر</label>
                            </div>


                        </div>





                        <div class="col-lg-12">
                            <label class="col-lg-12" style="margin: 20px 0px 20px 0px;font-weight: bold;">تنظیمات پیامک مهربونی</label>

                            <div class="form-check form-check-inline checkbox checkbox-primary mb-3">
                                <input class="form-check-input checkboxes checkbox_product check_active" type="checkbox" @if ($sms_order == 1) checked @endif name="sms_order">
                                <label class="form-check-label">ارسال پیامک (ایجاد سفارش ، تغییر سفارش ، وضعیت سفارش)</label>
                            </div>
                            <div class="form-check form-check-inline checkbox checkbox-primary mb-3">
                                <input class="form-check-input checkboxes checkbox_product check_active" type="checkbox" @if ($sms_goods == 1) checked @endif name="sms_goods">
                                <label class="form-check-label">ارسال پیامک ( مهربونی )</label>
                            </div>


                        </div>



                    </div>
                </div>
                <div class="card-footer">
                    <button class="btn btn-primary mr-2">ثبت</button>
                    <a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
                </div>
            </form>
            <!--end::Form-->
        </div>
    </div>
@endsection
