<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Middleware\Auth\AdminAccessMiddleware;
use App\Http\Middleware\Auth\ClientAccessMiddleware;
use App\Http\Middleware\Auth\ClientAccessNotActiveMiddleware;



//درگاه زرین پال شروع
Route::get('order', [App\Http\Controllers\portal\newZarinpalController::class, 'order']);//وقتی کابر از درگاه زرین پال بر میگردید
Route::get('zarinpal', [App\Http\Controllers\portal\newZarinpalController::class, 'add_order']);
//درگاه زرین پال پایان

//pay.ir شروع درگاه
Route::get('payir', [App\Http\Controllers\portal\payirController::class, 'add_order']);
Route::get('payir/callback', [App\Http\Controllers\portal\payirController::class, 'callback']);
//pay.ir پایان درگاه

//nextpay شروع درگاه
Route::get('nextpay', [App\Http\Controllers\portal\nextpayController::class, 'add_order']);
Route::get('/nextpayorder', [App\Http\Controllers\portal\nextpayController::class, 'callback']);
//nextpay پایان درگاه

//idpay شروع درگاه
Route::get('idpay', [App\Http\Controllers\portal\idpayController::class, 'add_order']);
Route::post('/idpayorder', [App\Http\Controllers\portal\idpayController::class, 'callback']);
//idpay پایان درگاه


//poolam شروع درگاه
Route::get('poolam', [App\Http\Controllers\portal\poolamController::class, 'add_order']);
Route::post('/poolamorder', [App\Http\Controllers\portal\poolamController::class, 'callback']);
//poolam پایان درگاه

//payping شروع درگاه
Route::get('payping', [App\Http\Controllers\portal\paypingController::class, 'add_order']);
Route::post('/paypingorder', [App\Http\Controllers\portal\paypingController::class, 'callback']);
//payping پایان درگاه


//zibal شروع درگاه
Route::get('zibal', [App\Http\Controllers\portal\zibalController::class, 'add_order']);
Route::get('/zibalorder', [App\Http\Controllers\portal\zibalController::class, 'callback']);
//zibal پایان درگاه

//vandar شروع درگاه
Route::get('vandar', [App\Http\Controllers\portal\vandarController::class, 'add_order']);
Route::get('/vandarorder', [App\Http\Controllers\portal\vandarController::class, 'callback']);
//vandar پایان درگاه



//-----------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------




//Route::get('/sendSmsFactorNotPay', [App\Http\Controllers\cronjob\orderCronJobController::class, 'sendSmsFactorNotPay']);


Route::get('/', [App\Http\Controllers\panel\indexController::class, 'index']);
Route::get('panel/index', [App\Http\Controllers\panel\indexController::class, 'index']);
Route::get('/index', [App\Http\Controllers\panel\indexController::class, 'index']);
Route::get('/home', [App\Http\Controllers\panel\indexController::class, 'index']);
//-----------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------

Route::middleware([AdminAccessMiddleware::class])->group(function () {
    Route::get('panel/portals', [App\Http\Controllers\panel\portalsController::class, 'index']);
    Route::post('panel/addZarinpal', [App\Http\Controllers\panel\portalsController::class, 'addZarinpal']);
    Route::post('panel/addPayir', [App\Http\Controllers\panel\portalsController::class, 'addPayir']);
    Route::post('panel/addNextPay', [App\Http\Controllers\panel\portalsController::class, 'addNextPay']);
    Route::post('panel/addIdPay', [App\Http\Controllers\panel\portalsController::class, 'addIdPay']);
    Route::post('panel/addPoolam', [App\Http\Controllers\panel\portalsController::class, 'addPoolam']);
    Route::post('panel/addZibal', [App\Http\Controllers\panel\portalsController::class, 'addZibal']);
    Route::post('panel/addPayPing', [App\Http\Controllers\panel\portalsController::class, 'addPayPing']);
    Route::post('panel/addVandar', [App\Http\Controllers\panel\portalsController::class, 'addVandar']);




    //شروع کاربران
    //---------------------------------------------------------------------------------------------------------------------------------------------

    Route::get('panel/addAdmin', [App\Http\Controllers\panel\adminController::class, 'addAdmin']);
    Route::post('panel/addAdmin', [App\Http\Controllers\panel\adminController::class, 'create']);
    Route::get('panel/allAdmin', [App\Http\Controllers\panel\adminController::class, 'allAdmin']);
    Route::get('panel/editAdmin/{id}', [App\Http\Controllers\panel\adminController::class, 'editAdmin']);
    Route::post('panel/editAdmin/{id}', [App\Http\Controllers\panel\adminController::class, 'updateAdmin']);
    Route::delete('panel/deleteAdmin/{id}', [App\Http\Controllers\panel\adminController::class, 'deleteAdmin']);




    Route::get('panel/addClient', [App\Http\Controllers\panel\clientController::class, 'addClient']);
    Route::post('panel/addClient', [App\Http\Controllers\panel\clientController::class, 'create']);
    Route::get('panel/editClient/{id}', [App\Http\Controllers\panel\clientController::class, 'editClient']);
    Route::post('panel/editClient/{id}', [App\Http\Controllers\panel\clientController::class, 'updateClient']);
    Route::get('panel/allClient', [App\Http\Controllers\panel\clientController::class, 'allClient']);
    Route::get('panel/allBlockClient', [App\Http\Controllers\panel\clientController::class, 'allBlockClient']);
    Route::delete('panel/deleteClient/{id}', [App\Http\Controllers\panel\clientController::class, 'deleteClient']);
    Route::get('panel/searchClient', [App\Http\Controllers\panel\clientController::class, 'searchClient']);
    Route::get('panel/searchBlockClient', [App\Http\Controllers\panel\clientController::class, 'searchBlockClient']);
    Route::get('panel/profileClient/{id}', [App\Http\Controllers\panel\clientController::class, 'profileClient']);
    Route::get('panel/accessClient', [App\Http\Controllers\panel\clientController::class, 'accessClient']);
    Route::post('panel/accessClient', [App\Http\Controllers\panel\clientController::class, 'updateAccessClient']);

    Route::get('panel/disableClient/{id}', [App\Http\Controllers\panel\clientController::class, 'disableClient']);
    Route::get('panel/activeClient/{id}', [App\Http\Controllers\panel\clientController::class, 'activeClient']);
    //---------------------------------------------------------------------------------------------------------------------------------------------

    //پایان کاربران


    
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/settings', [App\Http\Controllers\panel\settingsController::class, 'index']);
    Route::post('panel/settings', [App\Http\Controllers\panel\settingsController::class, 'settings']);
    Route::get('panel/allFactorNotPay', [App\Http\Controllers\panel\factorController::class, 'allFactorNotPay']);
    Route::get('panel/searchFactorNotPay', [App\Http\Controllers\panel\factorController::class, 'searchFactorNotPay']);
    Route::get('panel/allFactorPayed', [App\Http\Controllers\panel\factorController::class, 'allFactorPayed']);
    Route::get('panel/searchFactorPayed', [App\Http\Controllers\panel\factorController::class, 'searchFactorPayed']);

    Route::get('panel/factor/{id}', [App\Http\Controllers\panel\factorController::class, 'panelFactor']);
    Route::delete('panel/deleteFactor/{id}', [App\Http\Controllers\panel\factorController::class, 'deleteFactor']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addNews', [App\Http\Controllers\panel\newsController::class, 'addNews']);
    Route::post('panel/addNews', [App\Http\Controllers\panel\newsController::class, 'create']);
    Route::get('panel/editNews/{id}', [App\Http\Controllers\panel\newsController::class, 'editNews']);
    Route::post('panel/editNews/{id}', [App\Http\Controllers\panel\newsController::class, 'updateNews']);
    Route::delete('panel/deleteNews/{id}', [App\Http\Controllers\panel\newsController::class, 'deleteNews']);
    Route::get('panel/allNews', [App\Http\Controllers\panel\newsController::class, 'allNews']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/sendSms', [App\Http\Controllers\panel\smsController::class, 'sendSms']);
    Route::post('panel/sendSms', [App\Http\Controllers\panel\smsController::class, 'goSendSms']);
    Route::get('panel/sendSmsUser', [App\Http\Controllers\panel\smsController::class, 'sendSmsUser']);
    Route::post('panel/sendSmsUser', [App\Http\Controllers\panel\smsController::class, 'goSendSmsUser']);
    Route::post('panel/sendSmsUser/{id}', [App\Http\Controllers\panel\smsController::class, 'goSendSmsUser']);

    Route::get('panel/configurationSms', [App\Http\Controllers\panel\smsController::class, 'index']);
    Route::post('panel/configurationSmsIr', [App\Http\Controllers\panel\smsController::class, 'configurationSmsIr']);
    Route::post('panel/configurationKavenegar', [App\Http\Controllers\panel\smsController::class, 'configurationKavenegar']);
    Route::post('panel/configurationMeliPayamak', [App\Http\Controllers\panel\smsController::class, 'configurationMeliPayamak']);
    Route::post('panel/configurationIpPanel', [App\Http\Controllers\panel\smsController::class, 'configurationIpPanel']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/accessClient', [App\Http\Controllers\panel\clientController::class, 'accessClient']);
    Route::post('panel/accessClient', [App\Http\Controllers\panel\clientController::class, 'updateAccessClient']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addDepartment', [App\Http\Controllers\panel\departmentController::class, 'addDepartment']);
    Route::post('panel/addDepartment', [App\Http\Controllers\panel\departmentController::class, 'create']);
    Route::get('panel/editDepartment/{id}', [App\Http\Controllers\panel\departmentController::class, 'editDepartment']);
    Route::post('panel/editDepartment/{id}', [App\Http\Controllers\panel\departmentController::class, 'updateDepartment']);
    Route::delete('panel/deleteDepartment/{id}', [App\Http\Controllers\panel\departmentController::class, 'deleteDepartment']);
    Route::get('panel/allDepartment', [App\Http\Controllers\panel\departmentController::class, 'allDepartment']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addTicket', [App\Http\Controllers\panel\ticketController::class, 'addTicket']);
    Route::post('panel/addTicket', [App\Http\Controllers\panel\ticketController::class, 'create']);
    Route::get('panel/ticket/{id}', [App\Http\Controllers\panel\ticketController::class, 'ticket']);
    Route::post('panel/updateTicket/{id}', [App\Http\Controllers\panel\ticketController::class, 'updateTicket']);
    Route::get('panel/allTicket', [App\Http\Controllers\panel\ticketController::class, 'allTicket']);
    Route::get('panel/searchTicket', [App\Http\Controllers\panel\ticketController::class, 'searchTicket']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addAddressHome', [App\Http\Controllers\panel\addressHomeController::class, 'addAddressHome']);
    Route::post('panel/addAddressHome', [App\Http\Controllers\panel\addressHomeController::class, 'create']);
    Route::get('panel/editAddressHome/{id}', [App\Http\Controllers\panel\addressHomeController::class, 'editAddressHome']);
    Route::post('panel/editAddressHome/{id}', [App\Http\Controllers\panel\addressHomeController::class, 'updateAddressHome']);
    Route::delete('panel/deleteAddressHome/{id}', [App\Http\Controllers\panel\addressHomeController::class, 'deleteAddressHome']);
    Route::get('panel/allAddressHome', [App\Http\Controllers\panel\addressHomeController::class, 'allAddressHome']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addCategoryProduct', [App\Http\Controllers\panel\product\categoryProductController::class, 'addCategoryProduct']);
    Route::post('panel/addCategoryProduct', [App\Http\Controllers\panel\product\categoryProductController::class, 'create']);
    Route::get('panel/editCategoryProduct/{id}', [App\Http\Controllers\panel\product\categoryProductController::class, 'editCategoryProduct']);
    Route::post('panel/editCategoryProduct/{id}', [App\Http\Controllers\panel\product\categoryProductController::class, 'updateCategoryProduct']);
    Route::delete('panel/deleteCategoryProduct/{id}', [App\Http\Controllers\panel\product\categoryProductController::class, 'deleteCategoryProduct']);
    Route::get('panel/allCategoryProduct', [App\Http\Controllers\panel\product\categoryProductController::class, 'allCategoryProduct']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addProduct', [App\Http\Controllers\panel\product\productController::class, 'addProduct']);
    Route::post('panel/addProduct', [App\Http\Controllers\panel\product\productController::class, 'create']);
    Route::get('panel/editProduct/{id}', [App\Http\Controllers\panel\product\productController::class, 'editProduct']);
    Route::post('panel/editProduct/{id}', [App\Http\Controllers\panel\product\productController::class, 'updateProduct']);
    Route::delete('panel/deleteProduct/{id}', [App\Http\Controllers\panel\product\productController::class, 'deleteProduct']);
    Route::get('panel/allProduct', [App\Http\Controllers\panel\product\productController::class, 'allProduct']);
    Route::get('panel/allBuyProduct', [App\Http\Controllers\panel\product\productController::class, 'allBuyProduct']);
    Route::get('panel/searchFactorBuyProduct', [App\Http\Controllers\panel\product\productController::class, 'searchFactorBuyProduct']);
    Route::get('panel/profileProduct/{id}', [App\Http\Controllers\panel\product\productController::class, 'profileProduct']);
    Route::post('panel/changeOrder/{id}', [App\Http\Controllers\panel\product\productController::class, 'changeOrder']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addCategoryCampaign', [App\Http\Controllers\panel\campaign\categoryCampaignController::class, 'addCategoryCampaign']);
    Route::post('panel/addCategoryCampaign', [App\Http\Controllers\panel\campaign\categoryCampaignController::class, 'create']);
    Route::get('panel/editCategoryCampaign/{id}', [App\Http\Controllers\panel\campaign\categoryCampaignController::class, 'editCategoryCampaign']);
    Route::post('panel/editCategoryCampaign/{id}', [App\Http\Controllers\panel\campaign\categoryCampaignController::class, 'updateCategoryCampaign']);
    Route::delete('panel/deleteCategoryCampaign/{id}', [App\Http\Controllers\panel\campaign\categoryCampaignController::class, 'deleteCategoryCampaign']);
    Route::get('panel/allCategoryCampaign', [App\Http\Controllers\panel\campaign\categoryCampaignController::class, 'allCategoryCampaign']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('panel/addCampaign', [App\Http\Controllers\panel\campaign\campaignController::class, 'addCampaign']);
    Route::post('panel/addCampaign', [App\Http\Controllers\panel\campaign\campaignController::class, 'create']);
    Route::get('panel/editCampaign/{id}', [App\Http\Controllers\panel\campaign\campaignController::class, 'editCampaign']);
    Route::post('panel/editCampaign/{id}', [App\Http\Controllers\panel\campaign\campaignController::class, 'updateCampaign']);
    Route::delete('panel/deleteCampaign/{id}', [App\Http\Controllers\panel\campaign\campaignController::class, 'deleteCampaign']);
    Route::get('panel/allCampaign', [App\Http\Controllers\panel\campaign\campaignController::class, 'allCampaign']);
    Route::get('panel/profileCampaign/{id}', [App\Http\Controllers\panel\campaign\campaignController::class, 'profileCampaign']);





});




//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------



Route::get('client/index', [App\Http\Controllers\client\indexController::class, 'index']);

Route::middleware([ClientAccessMiddleware::class])->group(function () {

    
    Route::get('client/allFactorNotPay', [App\Http\Controllers\client\factorController::class, 'allFactorNotPay']);
    Route::get('client/allFactorPayed', [App\Http\Controllers\client\factorController::class, 'allFactorPayed']);
    Route::post('client/paymentFactorPortal/{id}', [App\Http\Controllers\client\factorController::class, 'paymentFactorPortal']);
    Route::get('client/factor/{id}', [App\Http\Controllers\client\factorController::class, 'panelFactor']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('client/allNews', [App\Http\Controllers\client\newsController::class, 'allNews']);
    Route::get('client/news/{id}', [App\Http\Controllers\client\newsController::class, 'news']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('client/addAddressHome', [App\Http\Controllers\client\addressHomeController::class, 'addAddressHome']);
    Route::post('client/addAddressHome', [App\Http\Controllers\client\addressHomeController::class, 'create']);
    Route::get('client/editAddressHome/{id}', [App\Http\Controllers\client\addressHomeController::class, 'editAddressHome']);
    Route::post('client/editAddressHome/{id}', [App\Http\Controllers\client\addressHomeController::class, 'updateAddressHome']);
    Route::get('client/allAddressHome', [App\Http\Controllers\client\addressHomeController::class, 'allAddressHome']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('client/allCampaign', [App\Http\Controllers\client\campaignController::class, 'allCampaign']);
    Route::get('client/searchCategoryCampaign/{id}', [App\Http\Controllers\client\campaignController::class, 'searchCategoryCampaign']);
    Route::get('client/campaign/{id}', [App\Http\Controllers\client\campaignController::class, 'campaign']);
    Route::post('client/crateFactorCampaign/{id}', [App\Http\Controllers\client\campaignController::class, 'crateFactorCampaign']);
    Route::get('client/allCampaignSupported', [App\Http\Controllers\client\campaignController::class, 'allCampaignSupported']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('client/addSubsidy', [App\Http\Controllers\client\subsidyController::class, 'addSubsidy']);
    Route::get('client/allSubsidy', [App\Http\Controllers\client\subsidyController::class, 'allSubsidy']);
    Route::post('client/addSubsidy', [App\Http\Controllers\client\subsidyController::class, 'create']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('client/buyProduct', [App\Http\Controllers\client\productController::class, 'buyProduct']);
    Route::get('client/searchCategoryProduct/{id}', [App\Http\Controllers\client\productController::class, 'searchCategoryProduct']);
    Route::get('client/allCart', [App\Http\Controllers\client\cartsController::class, 'allCart']);
    Route::get('client/allBuyProduct', [App\Http\Controllers\client\cartsController::class, 'allBuyProduct']);
    Route::post('client/createFactorCart', [App\Http\Controllers\client\cartsController::class, 'createFactorCart']);
    Route::post('client/addCart', [App\Http\Controllers\client\cartsController::class, 'addCart']);
    Route::post('client/cartIncrease', [App\Http\Controllers\client\cartsController::class, 'cartIncrease']);
    Route::post('client/cartDecrease', [App\Http\Controllers\client\cartsController::class, 'cartDecrease']);



    Route::get('client/allFactorNotPay', [App\Http\Controllers\client\factorController::class, 'allFactorNotPay']);
    Route::get('client/allFactorPayed', [App\Http\Controllers\client\factorController::class, 'allFactorPayed']);




});

Route::middleware([ClientAccessNotActiveMiddleware::class])->group(function () {
    Route::get('client/editClient/{id}', [App\Http\Controllers\client\profileController::class, 'profile']);
    Route::post('client/editClient/{id}', [App\Http\Controllers\client\profileController::class, 'editProfile']);
    Route::post('client/checkCodeSend', [App\Http\Controllers\client\profileController::class, 'checkCodeSend']);
    //---------------------------------------------------------------------------------------------------------------------------------------------
    Route::get('client/addTicket', [App\Http\Controllers\client\ticketController::class, 'addTicket']);
    Route::post('client/addTicket', [App\Http\Controllers\client\ticketController::class, 'create']);
    Route::get('client/ticket/{id}', [App\Http\Controllers\client\ticketController::class, 'ticket']);
    Route::post('client/updateTicket/{id}', [App\Http\Controllers\client\ticketController::class, 'updateTicket']);
    Route::get('client/allTicket', [App\Http\Controllers\client\ticketController::class, 'allTicket']);
    Route::get('client/searchTicket', [App\Http\Controllers\client\ticketController::class, 'searchTicket']);

});









Route::get('payFactor/{id}', [App\Http\Controllers\client\factorController::class, 'goToCheck']);
//---------------------------------------------------------------------------------------------------------------------------------------------
Route::post('captchaAjax', [App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'captchaAjax']);
Route::post('setCookieTheme', [App\Http\Controllers\panel\indexController::class, 'setCookieTheme']);
//---------------------------------------------------------------------------------------------------------------------------------------------
Route::post('/newLogin', [App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'newLogin']);
Route::get('/registerClient', [App\Http\Controllers\Auth\RegisteredUserController::class, 'registerClient']);
Route::post('/registerClient', [App\Http\Controllers\Auth\RegisteredUserController::class, 'createClient']);

Route::post('/newForgotPassword', [App\Http\Controllers\Auth\PasswordController::class, 'newForgotPassword']);
Route::get('/changePasswordClient', [App\Http\Controllers\Auth\PasswordController::class, 'changePasswordClient']);
Route::post('/changePasswordClient', [App\Http\Controllers\Auth\PasswordController::class, 'updatePasswordClient']);

require __DIR__.'/auth.php';
